/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import rars.Globals;
import rars.Settings;
import rars.venus.GuiAction;

public class SettingsExceptionHandlerAction
extends GuiAction {
    private JDialog exceptionHandlerDialog;
    private JCheckBox exceptionHandlerSetting;
    private JButton exceptionHandlerSelectionButton;
    private JTextField exceptionHandlerDisplay;
    private boolean initialSelected;
    private String initialPathname;

    public SettingsExceptionHandlerAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
        super(string, icon, string2, n, keyStroke);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.initialSelected = Globals.getSettings().getBooleanSetting(Settings.Bool.EXCEPTION_HANDLER_ENABLED);
        this.initialPathname = Globals.getSettings().getExceptionHandler();
        this.exceptionHandlerDialog = new JDialog(Globals.getGui(), "Exception Handler", true);
        this.exceptionHandlerDialog.setContentPane(this.buildDialogPanel());
        this.exceptionHandlerDialog.setDefaultCloseOperation(0);
        this.exceptionHandlerDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SettingsExceptionHandlerAction.this.closeDialog();
            }
        });
        this.exceptionHandlerDialog.pack();
        this.exceptionHandlerDialog.setLocationRelativeTo(Globals.getGui());
        this.exceptionHandlerDialog.setVisible(true);
    }

    private JPanel buildDialogPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(20, 20));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.exceptionHandlerSetting = new JCheckBox("Include this exception handler file in all assemble operations");
        this.exceptionHandlerSetting.setSelected(Globals.getSettings().getBooleanSetting(Settings.Bool.EXCEPTION_HANDLER_ENABLED));
        this.exceptionHandlerSetting.addActionListener(new ExceptionHandlerSettingAction());
        jPanel.add((Component)this.exceptionHandlerSetting, "North");
        JPanel jPanel2 = new JPanel();
        this.exceptionHandlerSelectionButton = new JButton("Browse");
        this.exceptionHandlerSelectionButton.setEnabled(this.exceptionHandlerSetting.isSelected());
        this.exceptionHandlerSelectionButton.addActionListener(new ExceptionHandlerSelectionAction());
        this.exceptionHandlerDisplay = new JTextField(Globals.getSettings().getExceptionHandler(), 30);
        this.exceptionHandlerDisplay.setEditable(false);
        this.exceptionHandlerDisplay.setEnabled(this.exceptionHandlerSetting.isSelected());
        jPanel2.add(this.exceptionHandlerSelectionButton);
        jPanel2.add(this.exceptionHandlerDisplay);
        jPanel.add((Component)jPanel2, "Center");
        Box box = Box.createHorizontalBox();
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsExceptionHandlerAction.this.performOK();
                SettingsExceptionHandlerAction.this.closeDialog();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsExceptionHandlerAction.this.closeDialog();
            }
        });
        box.add(Box.createHorizontalGlue());
        box.add(jButton);
        box.add(Box.createHorizontalGlue());
        box.add(jButton2);
        box.add(Box.createHorizontalGlue());
        jPanel.add((Component)box, "South");
        return jPanel;
    }

    private void performOK() {
        boolean bl = this.exceptionHandlerSetting.isSelected();
        String string = this.exceptionHandlerDisplay.getText();
        if (this.initialSelected != bl || this.initialPathname == null && string != null || this.initialPathname != null && !this.initialPathname.equals(string)) {
            Globals.getSettings().setBooleanSetting(Settings.Bool.EXCEPTION_HANDLER_ENABLED, bl);
            if (bl) {
                Globals.getSettings().setExceptionHandler(string);
            }
        }
    }

    private void closeDialog() {
        this.exceptionHandlerDialog.setVisible(false);
        this.exceptionHandlerDialog.dispose();
    }

    private class ExceptionHandlerSettingAction
    implements ActionListener {
        private ExceptionHandlerSettingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
            SettingsExceptionHandlerAction.this.exceptionHandlerSelectionButton.setEnabled(bl);
            SettingsExceptionHandlerAction.this.exceptionHandlerDisplay.setEnabled(bl);
        }
    }

    private class ExceptionHandlerSelectionAction
    implements ActionListener {
        private ExceptionHandlerSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            String string = Globals.getSettings().getExceptionHandler();
            if (string != null && (file = new File(string)).exists()) {
                jFileChooser.setSelectedFile(file);
            }
            if ((n = jFileChooser.showOpenDialog(Globals.getGui())) == 0) {
                string = jFileChooser.getSelectedFile().getPath();
                SettingsExceptionHandlerAction.this.exceptionHandlerDisplay.setText(string);
            }
        }
    }
}

