/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.registers;

import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.Register;
import rars.venus.NumberDisplayBaseChooser;
import rars.venus.registers.RegisterBlockWindow;

public class FloatingPointWindow
extends RegisterBlockWindow {
    private static final String[] regToolTips = new String[]{"floating point temporary", "floating point temporary", "floating point temporary", "floating point temporary", "floating point temporary", "floating point temporary", "floating point temporary", "floating point temporary", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "floating point argument / return value", "floating point argument / return value", "floating point argument", "floating point argument", "floating point argument", "floating point argument", "floating point argument", "floating point argument", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "floating point temporary", "floating point temporary", "floating point temporary", "floating point temporary"};

    public FloatingPointWindow() {
        super(FloatingPointRegisterFile.getRegisters(), regToolTips, "32-bit single precision IEEE 754 floating point");
    }

    @Override
    protected String formatRegister(Register register, int n) {
        long l = register.getValue();
        if ((l & 0xFFFFFFFF00000000L) == -4294967296L) {
            return NumberDisplayBaseChooser.formatFloatNumber((int)l, n);
        }
        return NumberDisplayBaseChooser.formatDoubleNumber(l, n);
    }

    @Override
    protected void beginObserving() {
        FloatingPointRegisterFile.addRegistersObserver(this);
    }

    @Override
    protected void endObserving() {
        FloatingPointRegisterFile.deleteRegistersObserver(this);
    }

    @Override
    protected void resetRegisters() {
        FloatingPointRegisterFile.resetRegisters();
    }
}

