/*
 * Decompiled with CFR 0.152.
 */
package rars.venus;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JMenu;
import rars.tools.Tool;
import rars.util.FilenameFinder;
import rars.venus.ToolAction;

public class ToolLoader {
    private static final String CLASS_PREFIX = "rars.tools.";
    private static final String TOOLS_DIRECTORY_PATH = "rars/tools";
    private static final String TOOLS_MENU_NAME = "Tools";
    private static final String TOOL_INTERFACE = "Tool.class";
    private static final String CLASS_EXTENSION = "class";

    public static JMenu buildToolsMenu() {
        JMenu jMenu = null;
        ArrayList<Tool> arrayList = ToolLoader.loadTools();
        if (!arrayList.isEmpty()) {
            jMenu = new JMenu(TOOLS_MENU_NAME);
            jMenu.setMnemonic(84);
            for (Tool tool : arrayList) {
                jMenu.add(new ToolAction(tool));
            }
        }
        return jMenu;
    }

    private static ArrayList<Tool> loadTools() {
        ArrayList<Tool> arrayList = new ArrayList<Tool>();
        ArrayList<String> arrayList2 = FilenameFinder.getFilenameList(ToolLoader.class.getClassLoader(), TOOLS_DIRECTORY_PATH, CLASS_EXTENSION);
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : arrayList2) {
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
            if (string.equals(TOOL_INTERFACE)) continue;
            try {
                String string2 = CLASS_PREFIX + string.substring(0, string.indexOf(CLASS_EXTENSION) - 1);
                Class<?> clazz = Class.forName(string2);
                if (!Tool.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) continue;
                arrayList.add((Tool)clazz.newInstance());
            }
            catch (Exception exception) {
                System.out.println("Error instantiating Tool from file " + string + ": " + exception);
            }
        }
        return arrayList;
    }
}

