/*
 * Decompiled with CFR 0.152.
 */
package rars.venus;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import rars.Globals;
import rars.ProgramStatement;
import rars.Settings;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.MemoryAccessNotice;
import rars.riscv.hardware.RegisterFile;
import rars.simulator.Simulator;
import rars.simulator.SimulatorNotice;
import rars.util.Binary;
import rars.util.EditorFont;
import rars.venus.MonoRightCellRenderer;
import rars.venus.NumberDisplayBaseChooser;

public class TextSegmentWindow
extends JInternalFrame
implements Observer {
    private JPanel programArgumentsPanel;
    private JTextField programArgumentsTextField;
    private static final int PROGRAM_ARGUMENT_TEXTFIELD_COLUMNS = 40;
    private JTable table;
    private JScrollPane tableScroller;
    private Object[][] data;
    private int[] intAddresses;
    private Hashtable<Integer, Integer> addressRows;
    private Hashtable<Integer, ModifiedCode> executeMods;
    private Container contentPane;
    private TextTableModel tableModel;
    private Font tableCellFont = new Font("Monospaced", 0, 12);
    private boolean codeHighlighting;
    private boolean breakpointsEnabled;
    private int highlightAddress;
    private TableModelListener tableModelListener;
    private static String[] columnNames = new String[]{"Bkpt", "Address", "Code", "Basic", "Source"};
    private static final int BREAK_COLUMN = 0;
    private static final int ADDRESS_COLUMN = 1;
    private static final int CODE_COLUMN = 2;
    private static final int BASIC_COLUMN = 3;
    private static final int SOURCE_COLUMN = 4;
    private static final Font monospacedPlain12Point = new Font("Monospaced", 0, 12);
    private static final String modifiedCodeMarker = " ------ ";

    public TextSegmentWindow() {
        super("Text Segment", true, false, true, true);
        Simulator.getInstance().addObserver(this);
        Globals.getSettings().addObserver(this);
        this.contentPane = this.getContentPane();
        this.codeHighlighting = true;
        this.breakpointsEnabled = true;
        this.programArgumentsPanel = new JPanel(new FlowLayout(0));
        this.programArgumentsPanel.add(new JLabel("Program Arguments: "));
        this.programArgumentsTextField = new JTextField(40);
        this.programArgumentsTextField.setToolTipText("Arguments provided to program at runtime via a0 (argc) and a1 (argv)");
        this.programArgumentsPanel.add(this.programArgumentsTextField);
    }

    public void setupTable() {
        int n;
        int n2 = Globals.getGui().getMainPane().getExecutePane().getAddressDisplayBase();
        this.codeHighlighting = true;
        this.breakpointsEnabled = true;
        ArrayList<ProgramStatement> arrayList = Globals.program.getMachineList();
        this.data = new Object[arrayList.size()][columnNames.length];
        this.intAddresses = new int[this.data.length];
        this.addressRows = new Hashtable(this.data.length);
        this.executeMods = new Hashtable(this.data.length);
        int n3 = 0;
        for (n = arrayList.size() - 1; n >= 0; --n) {
            ProgramStatement programStatement = arrayList.get(n);
            if (programStatement.getSourceLine() <= n3) continue;
            n3 = programStatement.getSourceLine();
        }
        n = ("" + n3).length();
        int n4 = 0;
        int n5 = -1;
        for (int i = 0; i < arrayList.size(); ++i) {
            ProgramStatement programStatement = arrayList.get(i);
            this.intAddresses[i] = programStatement.getAddress();
            this.addressRows.put(this.intAddresses[i], i);
            this.data[i][0] = false;
            this.data[i][1] = NumberDisplayBaseChooser.formatUnsignedInteger(programStatement.getAddress(), n2);
            this.data[i][2] = NumberDisplayBaseChooser.formatNumber(programStatement.getBinaryStatement(), 16);
            this.data[i][3] = programStatement.getPrintableBasicAssemblyStatement();
            Object object = "";
            if (!programStatement.getSource().equals("")) {
                n4 = n - ("" + programStatement.getSourceLine()).length();
                String string = "          ".substring(0, n4) + programStatement.getSourceLine() + ": ";
                if (programStatement.getSourceLine() == n5) {
                    string = "          ".substring(0, n) + "  ";
                }
                object = string + EditorFont.substituteSpacesForTabs(programStatement.getSource());
            }
            this.data[i][4] = object;
            n5 = programStatement.getSourceLine();
        }
        this.contentPane.removeAll();
        this.tableModel = new TextTableModel(this.data);
        if (this.tableModelListener != null) {
            this.tableModel.addTableModelListener(this.tableModelListener);
            this.tableModel.fireTableDataChanged();
        }
        this.table = new MyTippedJTable(this.tableModel);
        this.updateRowHeight();
        this.table.setRowSelectionAllowed(false);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(160);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(280);
        CodeCellRenderer codeCellRenderer = new CodeCellRenderer();
        this.table.getColumnModel().getColumn(3).setCellRenderer(codeCellRenderer);
        this.table.getColumnModel().getColumn(4).setCellRenderer(codeCellRenderer);
        this.table.getColumnModel().getColumn(1).setCellRenderer(new MonoRightCellRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new MachineCodeCellRenderer());
        this.table.getColumnModel().getColumn(0).setCellRenderer(new CheckBoxTableCellRenderer());
        this.reorderColumns();
        this.table.getColumnModel().addColumnModelListener(new MyTableColumnMovingListener());
        this.tableScroller = new JScrollPane(this.table, 22, 32);
        this.contentPane.add(this.tableScroller);
        if (Globals.getSettings().getBooleanSetting(Settings.Bool.PROGRAM_ARGUMENTS)) {
            this.addProgramArgumentsPanel();
        }
        this.deleteAsTextSegmentObserver();
        if (Globals.getSettings().getBooleanSetting(Settings.Bool.SELF_MODIFYING_CODE_ENABLED)) {
            this.addAsTextSegmentObserver();
        }
    }

    public String getProgramArguments() {
        return this.programArgumentsTextField.getText();
    }

    public void addProgramArgumentsPanel() {
        if (this.contentPane != null && this.contentPane.getComponentCount() > 0) {
            this.contentPane.add((Component)this.programArgumentsPanel, "North");
            this.contentPane.validate();
        }
    }

    public void removeProgramArgumentsPanel() {
        if (this.contentPane != null) {
            this.contentPane.remove(this.programArgumentsPanel);
            this.contentPane.validate();
        }
    }

    public void clearWindow() {
        this.contentPane.removeAll();
    }

    public void registerTableModelListener(TableModelListener tableModelListener) {
        this.tableModelListener = tableModelListener;
    }

    public void updateCodeAddresses() {
        if (this.contentPane.getComponentCount() == 0) {
            return;
        }
        int n = Globals.getGui().getMainPane().getExecutePane().getAddressDisplayBase();
        for (int i = 0; i < this.intAddresses.length; ++i) {
            String string = NumberDisplayBaseChooser.formatUnsignedInteger(this.intAddresses[i], n);
            this.table.getModel().setValueAt(string, i, 1);
        }
    }

    public void updateBasicStatements() {
        if (this.contentPane.getComponentCount() == 0) {
            return;
        }
        ArrayList<ProgramStatement> arrayList = Globals.program.getMachineList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ProgramStatement programStatement;
            if (this.executeMods.get(i) == null) {
                programStatement = arrayList.get(i);
                this.table.getModel().setValueAt(programStatement.getPrintableBasicAssemblyStatement(), i, 3);
                continue;
            }
            try {
                programStatement = new ProgramStatement(Binary.stringToInt((String)this.table.getModel().getValueAt(i, 2)), Binary.stringToInt((String)this.table.getModel().getValueAt(i, 1)));
                this.table.getModel().setValueAt(programStatement.getPrintableBasicAssemblyStatement(), i, 3);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.table.getModel().setValueAt("", i, 3);
            }
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        MemoryAccessNotice memoryAccessNotice;
        if (observable == Simulator.getInstance()) {
            SimulatorNotice simulatorNotice = (SimulatorNotice)object;
            if (simulatorNotice.getAction() == 0) {
                this.deleteAsTextSegmentObserver();
                if (Globals.getSettings().getBooleanSetting(Settings.Bool.SELF_MODIFYING_CODE_ENABLED)) {
                    this.addAsTextSegmentObserver();
                }
            }
        } else if (observable == Globals.getSettings()) {
            this.deleteAsTextSegmentObserver();
            if (Globals.getSettings().getBooleanSetting(Settings.Bool.SELF_MODIFYING_CODE_ENABLED)) {
                this.addAsTextSegmentObserver();
            }
            this.updateRowHeight();
        } else if (object instanceof MemoryAccessNotice && (memoryAccessNotice = (MemoryAccessNotice)object).getAccessType() == 1) {
            int n = memoryAccessNotice.getAddress();
            int n2 = memoryAccessNotice.getValue();
            String string = Binary.intToHexString(memoryAccessNotice.getValue());
            String string2 = modifiedCodeMarker;
            String string3 = modifiedCodeMarker;
            int n3 = 0;
            try {
                n3 = this.findRowForAddress(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            ModifiedCode modifiedCode = this.executeMods.get(n3);
            if (modifiedCode == null) {
                if (this.tableModel.getValueAt(n3, 2).equals(string)) {
                    return;
                }
                modifiedCode = new ModifiedCode(n3, this.tableModel.getValueAt(n3, 2), this.tableModel.getValueAt(n3, 3), this.tableModel.getValueAt(n3, 4));
                this.executeMods.put(n3, modifiedCode);
                string2 = new ProgramStatement(n2, n).getPrintableBasicAssemblyStatement();
            } else if (modifiedCode.getCode().equals(string)) {
                string2 = (String)modifiedCode.getBasic();
                string3 = (String)modifiedCode.getSource();
                this.executeMods.remove(n3);
            } else {
                string2 = new ProgramStatement(n2, n).getPrintableBasicAssemblyStatement();
            }
            this.data[n3][2] = string;
            this.tableModel.fireTableCellUpdated(n3, 2);
            this.tableModel.setValueAt(string2, n3, 3);
            this.tableModel.setValueAt(string3, n3, 4);
            try {
                Globals.getGui().getMainPane().getExecutePane().getDataSegmentWindow().update(Memory.getInstance(), new MemoryAccessNotice(1, n, n2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void resetModifiedSourceCode() {
        if (this.executeMods != null && !this.executeMods.isEmpty()) {
            Enumeration<ModifiedCode> enumeration = this.executeMods.elements();
            while (enumeration.hasMoreElements()) {
                ModifiedCode modifiedCode = enumeration.nextElement();
                this.tableModel.setValueAt(modifiedCode.getCode(), modifiedCode.getRow(), 2);
                this.tableModel.setValueAt(modifiedCode.getBasic(), modifiedCode.getRow(), 3);
                this.tableModel.setValueAt(modifiedCode.getSource(), modifiedCode.getRow(), 4);
            }
            this.executeMods.clear();
        }
    }

    int getIntCodeAddressAtRow(int n) {
        return this.intAddresses[n];
    }

    public int getBreakpointCount() {
        int n = 0;
        for (Object[] objectArray : this.data) {
            if (!((Boolean)objectArray[0]).booleanValue()) continue;
            ++n;
        }
        return n;
    }

    public int[] getSortedBreakPointsArray() {
        int n = this.getBreakpointCount();
        if (n == 0 || !this.breakpointsEnabled) {
            return null;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (!((Boolean)this.data[i][0]).booleanValue()) continue;
            nArray[n++] = this.intAddresses[i];
        }
        Arrays.sort(nArray);
        return nArray;
    }

    public void clearAllBreakpoints() {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (!((Boolean)this.data[i][0]).booleanValue()) continue;
            this.tableModel.setValueAt(false, i, 0);
        }
        ((JCheckBox)((DefaultCellEditor)this.table.getCellEditor(0, 0)).getComponent()).setSelected(false);
    }

    public void highlightStepAtPC() {
        this.highlightStepAtAddress(RegisterFile.getProgramCounter());
    }

    public void highlightStepAtAddress(int n) {
        this.highlightAddress = n;
        int n2 = 0;
        try {
            n2 = this.findRowForAddress(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        this.table.scrollRectToVisible(this.table.getCellRect(n2, 0, true));
        this.table.tableChanged(new TableModelEvent(this.tableModel));
    }

    public void setCodeHighlighting(boolean bl) {
        this.codeHighlighting = bl;
    }

    public boolean getCodeHighlighting() {
        return this.codeHighlighting;
    }

    public void unhighlightAllSteps() {
        boolean bl = this.getCodeHighlighting();
        this.setCodeHighlighting(false);
        this.table.tableChanged(new TableModelEvent(this.tableModel, 0, this.data.length - 1, 3));
        this.table.tableChanged(new TableModelEvent(this.tableModel, 0, this.data.length - 1, 4));
        this.setCodeHighlighting(bl);
    }

    void selectStepAtAddress(int n) {
        MouseListener[] mouseListenerArray;
        int n2 = 0;
        try {
            n2 = this.findRowForAddress(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        int n3 = this.table.convertColumnIndexToView(4);
        Rectangle rectangle = this.table.getCellRect(n2, n3, true);
        double d = rectangle.getHeight();
        double d2 = this.tableScroller.getViewport().getExtentSize().getHeight();
        int n4 = (int)(d2 / d);
        int n5 = Math.max((int)((double)(n2 - n4 / 2) * d), 0);
        this.tableScroller.getViewport().setViewPosition(new Point(0, n5));
        MouseEvent mouseEvent = new MouseEvent(this.table, 501, new Date().getTime(), 16, (int)rectangle.getX() + 1, (int)rectangle.getY() + 1, 1, false);
        for (MouseListener mouseListener : mouseListenerArray = this.table.getMouseListeners()) {
            mouseListener.mousePressed(mouseEvent);
        }
    }

    public void toggleBreakpoints() {
        MouseListener[] mouseListenerArray;
        Rectangle rectangle = ((MyTippedJTable)this.table).getRectForColumnIndex(0);
        MouseEvent mouseEvent = new MouseEvent(this.table, 500, new Date().getTime(), 16, (int)rectangle.getX(), (int)rectangle.getY(), 1, false);
        for (MouseListener mouseListener : mouseListenerArray = ((MyTippedJTable)this.table).tableHeader.getMouseListeners()) {
            mouseListener.mouseClicked(mouseEvent);
        }
    }

    private void addAsTextSegmentObserver() {
        try {
            Memory.getInstance().addObserver(this, Memory.textBaseAddress, Memory.dataSegmentBaseAddress);
        }
        catch (AddressErrorException addressErrorException) {
            // empty catch block
        }
    }

    private void deleteAsTextSegmentObserver() {
        Memory.getInstance().deleteObserver(this);
    }

    private void reorderColumns() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        int[] nArray = Globals.getSettings().getTextColumnOrder();
        if (nArray.length == this.table.getColumnCount()) {
            for (int n : nArray) {
                defaultTableColumnModel.addColumn(tableColumnModel.getColumn(n));
            }
            this.table.setColumnModel(defaultTableColumnModel);
        }
    }

    private int findRowForAddress(int n) throws IllegalArgumentException {
        int n2 = 0;
        try {
            n2 = this.addressRows.get(n);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException();
        }
        return n2;
    }

    private void updateRowHeight() {
        if (this.table == null) {
            return;
        }
        Font[] fontArray = new Font[]{Globals.getSettings().getFontByPosition(3), Globals.getSettings().getFontByPosition(1), Globals.getSettings().getFontByPosition(2)};
        int n = 0;
        for (int i = 0; i < fontArray.length; ++i) {
            int n2 = this.getFontMetrics(fontArray[i]).getHeight();
            if (n2 <= n) continue;
            n = n2;
        }
        this.table.setRowHeight(n);
    }

    class TextTableModel
    extends AbstractTableModel {
        Object[][] data;

        public TextTableModel(Object[][] objectArray) {
            this.data = objectArray;
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int n) {
            return columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0 || n2 == 2 && Globals.getSettings().getBooleanSetting(Settings.Bool.SELF_MODIFYING_CODE_ENABLED);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 2) {
                this.data[n][n2] = object;
                this.fireTableCellUpdated(n, n2);
                return;
            }
            int n3 = 0;
            int n4 = 0;
            if (object.equals(this.data[n][n2])) {
                return;
            }
            try {
                n3 = Binary.stringToInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                this.data[n][n2] = "INVALID";
                this.fireTableCellUpdated(n, n2);
                return;
            }
            try {
                n4 = Binary.stringToInt((String)this.data[n][1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Globals.memoryAndRegistersLock.lock();
            try {
                try {
                    Globals.memory.setRawWord(n4, n3);
                }
                catch (AddressErrorException addressErrorException) {
                    Globals.memoryAndRegistersLock.unlock();
                    return;
                }
            }
            finally {
                Globals.memoryAndRegistersLock.unlock();
            }
        }

        private void printDebugData() {
            int n = this.getRowCount();
            int n2 = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < n2; ++j) {
                    System.out.print("  " + this.data[i][j]);
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }

    private class MyTippedJTable
    extends JTable {
        private JTableHeader tableHeader;
        private String[] columnToolTips;

        MyTippedJTable(TextTableModel textTableModel) {
            super(textTableModel);
            this.columnToolTips = new String[]{"If checked, will set an execution breakpoint. Click header to disable/enable breakpoints", "Text segment address of binary instruction code", "32-bit binary RISCV instruction", "Basic assembler instruction", "Source code line"};
        }

        @Override
        protected JTableHeader createDefaultTableHeader() {
            this.tableHeader = new TextTableHeader(this.columnModel);
            return this.tableHeader;
        }

        public Rectangle getRectForColumnIndex(int n) {
            for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
                if (this.columnModel.getColumn(i).getModelIndex() != n) continue;
                return this.tableHeader.getHeaderRect(i);
            }
            return this.tableHeader.getHeaderRect(n);
        }

        private class TextTableHeader
        extends JTableHeader {
            public TextTableHeader(TableColumnModel tableColumnModel) {
                super(tableColumnModel);
                this.addMouseListener(new TextTableHeaderMouseListener());
            }

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.columnModel.getColumnIndexAtX(point.x);
                int n2 = this.columnModel.getColumn(n).getModelIndex();
                return MyTippedJTable.this.columnToolTips[n2];
            }

            private class TextTableHeaderMouseListener
            implements MouseListener {
                private TextTableHeaderMouseListener() {
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    int n = TextTableHeader.this.columnModel.getColumnIndexAtX(point.x);
                    int n2 = TextTableHeader.this.columnModel.getColumn(n).getModelIndex();
                    if (n2 == 0) {
                        JCheckBox jCheckBox = (JCheckBox)((DefaultCellEditor)TextTableHeader.this.table.getCellEditor(0, n)).getComponent();
                        TextSegmentWindow.this.breakpointsEnabled = !TextSegmentWindow.this.breakpointsEnabled;
                        jCheckBox.setEnabled(TextSegmentWindow.this.breakpointsEnabled);
                        TextTableHeader.this.table.tableChanged(new TableModelEvent(TextSegmentWindow.this.tableModel, 0, TextSegmentWindow.this.data.length - 1, 0));
                    }
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                }
            }
        }
    }

    class CodeCellRenderer
    extends DefaultTableCellRenderer {
        CodeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            TextSegmentWindow textSegmentWindow = Globals.getGui().getMainPane().getExecutePane().getTextSegmentWindow();
            Settings settings = Globals.getSettings();
            boolean bl3 = textSegmentWindow.getCodeHighlighting();
            if (bl3 && textSegmentWindow.getIntCodeAddressAtRow(n) == TextSegmentWindow.this.highlightAddress) {
                component.setBackground(settings.getColorSettingByPosition(4));
                component.setForeground(settings.getColorSettingByPosition(5));
                component.setFont(settings.getFontByPosition(3));
            } else if (n % 2 == 0) {
                component.setBackground(settings.getColorSettingByPosition(0));
                component.setForeground(settings.getColorSettingByPosition(1));
                component.setFont(settings.getFontByPosition(1));
            } else {
                component.setBackground(settings.getColorSettingByPosition(2));
                component.setForeground(settings.getColorSettingByPosition(3));
                component.setFont(settings.getFontByPosition(2));
            }
            return component;
        }
    }

    class MachineCodeCellRenderer
    extends DefaultTableCellRenderer {
        MachineCodeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setFont(MonoRightCellRenderer.MONOSPACED_PLAIN_12POINT);
            jLabel.setHorizontalAlignment(4);
            if (n % 2 == 0) {
                jLabel.setBackground(Globals.getSettings().getColorSettingByPosition(0));
                jLabel.setForeground(Globals.getSettings().getColorSettingByPosition(1));
            } else {
                jLabel.setBackground(Globals.getSettings().getColorSettingByPosition(2));
                jLabel.setForeground(Globals.getSettings().getColorSettingByPosition(3));
            }
            return jLabel;
        }
    }

    class CheckBoxTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        Border noFocusBorder;
        Border focusBorder;

        public CheckBoxTableCellRenderer() {
            this.setContentAreaFilled(true);
            this.setBorderPainted(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable != null) {
                if (bl) {
                    this.setForeground(jTable.getSelectionForeground());
                    this.setBackground(jTable.getSelectionBackground());
                } else {
                    this.setForeground(jTable.getForeground());
                    this.setBackground(jTable.getBackground());
                }
                this.setEnabled(jTable.isEnabled() && TextSegmentWindow.this.breakpointsEnabled);
                this.setComponentOrientation(jTable.getComponentOrientation());
                if (bl2) {
                    if (this.focusBorder == null) {
                        this.focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
                    }
                    this.setBorder(this.focusBorder);
                } else {
                    if (this.noFocusBorder == null) {
                        if (this.focusBorder == null) {
                            this.focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
                        }
                        if (this.focusBorder != null) {
                            Insets insets = this.focusBorder.getBorderInsets(this);
                            this.noFocusBorder = new EmptyBorder(insets);
                        }
                    }
                    this.setBorder(this.noFocusBorder);
                }
                this.setSelected(Boolean.TRUE.equals(object));
            }
            return this;
        }
    }

    private class MyTableColumnMovingListener
    implements TableColumnModelListener {
        private MyTableColumnMovingListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            int[] nArray = new int[TextSegmentWindow.this.table.getColumnCount()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = TextSegmentWindow.this.table.getColumnModel().getColumn(i).getModelIndex();
            }
            int[] nArray2 = Globals.getSettings().getTextColumnOrder();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray2[i] == nArray[i]) continue;
                Globals.getSettings().setTextColumnOrder(nArray);
                break;
            }
        }
    }

    private class ModifiedCode {
        private Integer row;
        private Object code;
        private Object basic;
        private Object source;

        private ModifiedCode(Integer n, Object object, Object object2, Object object3) {
            this.row = n;
            this.code = object;
            this.basic = object2;
            this.source = object3;
        }

        private Integer getRow() {
            return this.row;
        }

        private Object getCode() {
            return this.code;
        }

        private Object getBasic() {
            return this.basic;
        }

        private Object getSource() {
            return this.source;
        }
    }
}

