/*
 * Decompiled with CFR 0.152.
 */
package rars.venus;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.concurrent.ArrayBlockingQueue;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.undo.UndoableEdit;
import rars.Globals;
import rars.simulator.Simulator;
import rars.venus.EditPane;
import rars.venus.EditTabbedPane;

public class MessagesPane
extends JTabbedPane {
    JTextArea assemble;
    JTextArea run;
    private JPanel assembleTab;
    private JPanel runTab;
    public static final int MAXIMUM_SCROLLED_CHARACTERS = Globals.maximumMessageCharacters;
    public static final int NUMBER_OF_CHARACTERS_TO_CUT = Globals.maximumMessageCharacters / 10;

    public MessagesPane() {
        this.setMinimumSize(new Dimension(0, 0));
        this.assemble = new JTextArea();
        this.run = new JTextArea();
        this.assemble.setEditable(false);
        this.run.setEditable(false);
        Font font = new Font("Monospaced", 0, 12);
        this.assemble.setFont(font);
        this.run.setFont(font);
        JButton jButton = new JButton("Clear");
        jButton.setToolTipText("Clear the Messages area");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MessagesPane.this.assemble.setText("");
            }
        });
        this.assembleTab = new JPanel(new BorderLayout());
        this.assembleTab.add((Component)this.createBoxForButton(jButton), "West");
        this.assembleTab.add((Component)new JScrollPane(this.assemble, 20, 30), "Center");
        this.assemble.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                String string;
                int n;
                int n2 = 0;
                int n3 = 0;
                try {
                    n = MessagesPane.this.assemble.getLineOfOffset(MessagesPane.this.assemble.viewToModel(mouseEvent.getPoint()));
                    n2 = MessagesPane.this.assemble.getLineStartOffset(n);
                    n3 = MessagesPane.this.assemble.getLineEndOffset(n);
                    string = MessagesPane.this.assemble.getText(n2, n3 - n2);
                }
                catch (BadLocationException badLocationException) {
                    string = "";
                }
                if (string.length() > 0 && (string.startsWith("Error") || string.startsWith("Warning"))) {
                    int n4;
                    MessagesPane.this.assemble.select(n2, n3);
                    MessagesPane.this.assemble.setSelectionColor(Color.YELLOW);
                    MessagesPane.this.assemble.setSelectedTextColor(Color.BLACK);
                    MessagesPane.this.assemble.repaint();
                    n = string.indexOf(": ");
                    if (n >= 0) {
                        string = string.substring(0, n);
                    }
                    String[] stringArray = string.split("\\s");
                    String string2 = " line ".trim();
                    String string3 = " column ".trim();
                    String string4 = "";
                    String string5 = "";
                    for (n4 = 0; n4 < stringArray.length; ++n4) {
                        if (stringArray[n4].equals(string2) && n4 < stringArray.length - 1) {
                            string4 = stringArray[n4 + 1];
                        }
                        if (!stringArray[n4].equals(string3) || n4 >= stringArray.length - 1) continue;
                        string5 = stringArray[n4 + 1];
                    }
                    n4 = 0;
                    int n5 = 0;
                    try {
                        n4 = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n4 = 0;
                    }
                    try {
                        n5 = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n5 = 0;
                    }
                    int n6 = string.indexOf(" in ") + " in ".length();
                    int n7 = string.indexOf(" line ");
                    String string6 = "";
                    if (n6 < n7 && n6 >= " in ".length()) {
                        string6 = string.substring(n6, n7).trim();
                    }
                    if (string6 != null && string6.length() > 0) {
                        MessagesPane.this.selectEditorTextLine(string6, n4, n5);
                        MessagesPane.this.selectErrorMessage(string6, n4, n5);
                    }
                }
            }
        });
        JButton jButton2 = new JButton("Clear");
        jButton2.setToolTipText("Clear the Run I/O area");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MessagesPane.this.run.setText("");
            }
        });
        this.runTab = new JPanel(new BorderLayout());
        this.runTab.add((Component)this.createBoxForButton(jButton2), "West");
        this.runTab.add((Component)new JScrollPane(this.run, 20, 30), "Center");
        this.addTab("Messages", this.assembleTab);
        this.addTab("Run I/O", this.runTab);
        this.setForeground(Color.BLACK);
        this.setToolTipTextAt(0, "Messages produced by Run menu. Click on assemble error message to select erroneous line");
        this.setToolTipTextAt(1, "Simulated console input and output");
    }

    private Box createBoxForButton(JButton jButton) {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(6));
        box.add(jButton);
        box.add(Box.createHorizontalStrut(6));
        Box box2 = Box.createVerticalBox();
        box2.add(Box.createVerticalGlue());
        box2.add(box);
        box2.add(Box.createVerticalGlue());
        return box2;
    }

    public void selectErrorMessage(String string, int n, int n2) {
        String string2 = new File(string).getName() + " line " + n + " column " + n2;
        int n3 = this.assemble.getText().lastIndexOf(string2);
        if (n3 >= 0) {
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            try {
                n4 = this.assemble.getLineOfOffset(n3);
                n5 = this.assemble.getLineStartOffset(n4);
                n6 = this.assemble.getLineEndOffset(n4);
                this.assemble.setSelectionColor(Color.YELLOW);
                this.assemble.setSelectedTextColor(Color.BLACK);
                this.assemble.select(n5, n6);
                this.assemble.getCaret().setSelectionVisible(true);
                this.assemble.repaint();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void selectEditorTextLine(String string, int n, int n2) {
        EditTabbedPane editTabbedPane = (EditTabbedPane)Globals.getGui().getMainPane().getEditTabbedPane();
        EditPane editPane = null;
        EditPane editPane2 = editTabbedPane.getEditPaneForFile(new File(string).getPath());
        if (editPane2 != null) {
            if (editPane2 != editTabbedPane.getCurrentEditTab()) {
                editTabbedPane.setCurrentEditTab(editPane2);
            }
            editPane = editPane2;
        } else if (editTabbedPane.openFile(new File(string))) {
            editPane = editTabbedPane.getCurrentEditTab();
        }
        if (editPane2 != null && editPane != null) {
            editPane.selectLine(n, n2);
        }
    }

    public JTextArea getAssembleTextArea() {
        return this.assemble;
    }

    public JTextArea getRunTextArea() {
        return this.run;
    }

    public void postMessage(String string) {
        this.assemble.append(string);
        if (this.assemble.getDocument().getLength() > MAXIMUM_SCROLLED_CHARACTERS) {
            try {
                this.assemble.getDocument().remove(0, NUMBER_OF_CHARACTERS_TO_CUT);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.assemble.setCaretPosition(this.assemble.getDocument().getLength());
        this.setSelectedComponent(this.assembleTab);
    }

    public void postRunMessage(String string) {
        final String string2 = string;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MessagesPane.this.setSelectedComponent(MessagesPane.this.runTab);
                MessagesPane.this.run.append(string2);
                if (MessagesPane.this.run.getDocument().getLength() > MAXIMUM_SCROLLED_CHARACTERS) {
                    try {
                        MessagesPane.this.run.getDocument().remove(0, NUMBER_OF_CHARACTERS_TO_CUT);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void selectMessageTab() {
        this.setSelectedComponent(this.assembleTab);
    }

    public void selectRunMessageTab() {
        this.setSelectedComponent(this.runTab);
    }

    public String getInputString(String string) {
        boolean bl = Globals.memoryAndRegistersLock.isHeldByCurrentThread();
        if (bl) {
            Globals.memoryAndRegistersLock.unlock();
        }
        JOptionPane jOptionPane = new JOptionPane(string, 3, -1);
        jOptionPane.setWantsInput(true);
        JDialog jDialog = jOptionPane.createDialog(Globals.getGui(), "Keyboard Input");
        jDialog.setVisible(true);
        String string2 = (String)jOptionPane.getInputValue();
        this.postRunMessage(Globals.userInputAlert + string2 + "\n");
        if (bl) {
            Globals.memoryAndRegistersLock.lock();
        }
        return string2;
    }

    public String getInputString(int n) {
        boolean bl = Globals.memoryAndRegistersLock.isHeldByCurrentThread();
        if (bl) {
            Globals.memoryAndRegistersLock.unlock();
        }
        Asker asker = new Asker(n);
        String string = asker.response();
        if (bl) {
            Globals.memoryAndRegistersLock.lock();
        }
        return string;
    }

    class Asker
    implements Runnable {
        ArrayBlockingQueue<String> resultQueue = new ArrayBlockingQueue(1);
        int initialPos;
        int maxLen;
        final DocumentListener listener = new DocumentListener(){

            @Override
            public void insertUpdate(final DocumentEvent documentEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String string = documentEvent.getDocument().getText(documentEvent.getOffset(), documentEvent.getLength());
                            int n = string.indexOf(10);
                            if (n >= 0) {
                                int n2 = documentEvent.getOffset() + n;
                                if (n2 + 1 == documentEvent.getDocument().getLength()) {
                                    Asker.this.returnResponse();
                                } else {
                                    documentEvent.getDocument().remove(n2, 1);
                                    documentEvent.getDocument().insertString(documentEvent.getDocument().getLength(), "\n", null);
                                }
                            } else if (Asker.this.maxLen >= 0 && documentEvent.getDocument().getLength() - Asker.this.initialPos >= Asker.this.maxLen) {
                                Asker.this.returnResponse();
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            Asker.this.returnResponse();
                        }
                    }
                });
            }

            @Override
            public void removeUpdate(final DocumentEvent documentEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if ((documentEvent.getDocument().getLength() < Asker.this.initialPos || documentEvent.getOffset() < Asker.this.initialPos) && documentEvent instanceof UndoableEdit) {
                            ((UndoableEdit)((Object)documentEvent)).undo();
                            MessagesPane.this.run.setCaretPosition(documentEvent.getOffset() + documentEvent.getLength());
                        }
                    }
                });
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        final NavigationFilter navigationFilter = new NavigationFilter(){

            @Override
            public void moveDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
                if (n < Asker.this.initialPos) {
                    n = Math.min(Asker.this.initialPos, MessagesPane.this.run.getDocument().getLength());
                }
                filterBypass.moveDot(n, bias);
            }

            @Override
            public void setDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
                if (n < Asker.this.initialPos) {
                    n = Math.min(Asker.this.initialPos, MessagesPane.this.run.getDocument().getLength());
                }
                filterBypass.setDot(n, bias);
            }
        };
        final Simulator.StopListener stopListener = new Simulator.StopListener(){

            @Override
            public void stopped(Simulator simulator) {
                Asker.this.returnResponse();
            }
        };

        Asker(int n) {
            this.maxLen = n;
        }

        @Override
        public void run() {
            MessagesPane.this.selectRunMessageTab();
            MessagesPane.this.run.setEditable(true);
            MessagesPane.this.run.requestFocusInWindow();
            MessagesPane.this.run.setCaretPosition(MessagesPane.this.run.getDocument().getLength());
            this.initialPos = MessagesPane.this.run.getCaretPosition();
            MessagesPane.this.run.setNavigationFilter(this.navigationFilter);
            MessagesPane.this.run.getDocument().addDocumentListener(this.listener);
            Simulator.getInstance().addStopListener(this.stopListener);
        }

        void cleanup() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessagesPane.this.run.getDocument().removeDocumentListener(Asker.this.listener);
                    MessagesPane.this.run.setEditable(false);
                    MessagesPane.this.run.setNavigationFilter(null);
                    MessagesPane.this.run.setCaretPosition(MessagesPane.this.run.getDocument().getLength());
                    Simulator.getInstance().removeStopListener(Asker.this.stopListener);
                }
            });
        }

        void returnResponse() {
            try {
                int n = Math.min(this.initialPos, MessagesPane.this.run.getDocument().getLength());
                int n2 = Math.min(MessagesPane.this.run.getDocument().getLength() - n, this.maxLen >= 0 ? this.maxLen : Integer.MAX_VALUE);
                this.resultQueue.offer(MessagesPane.this.run.getText(n, n2));
            }
            catch (BadLocationException badLocationException) {
                this.resultQueue.offer("");
            }
        }

        String response() {
            EventQueue.invokeLater(this);
            try {
                String string = this.resultQueue.take();
                return string;
            }
            catch (InterruptedException interruptedException) {
                String string = null;
                return string;
            }
            finally {
                this.cleanup();
            }
        }
    }
}

