/*
 * Decompiled with CFR 0.152.
 */
package rars.venus;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import rars.Globals;
import rars.RISCVprogram;
import rars.assembler.Symbol;
import rars.assembler.SymbolTable;
import rars.riscv.hardware.Memory;
import rars.util.Binary;
import rars.venus.MonoRightCellRenderer;
import rars.venus.NumberDisplayBaseChooser;
import rars.venus.run.RunAssembleAction;

public class LabelsWindow
extends JInternalFrame {
    private Container contentPane;
    private JPanel labelPanel;
    private JCheckBox dataLabels;
    private JCheckBox textLabels;
    private ArrayList<LabelsForSymbolTable> listOfLabelsForSymbolTable;
    private LabelsWindow labelsWindow;
    private static final int MAX_DISPLAYED_CHARS = 24;
    private static final int PREFERRED_NAME_COLUMN_WIDTH = 60;
    private static final int PREFERRED_ADDRESS_COLUMN_WIDTH = 60;
    private static final int LABEL_COLUMN = 0;
    private static final int ADDRESS_COLUMN = 1;
    private static final String[] columnToolTips = new String[]{"Programmer-defined label (identifier).", "Text or data segment address at which label is defined."};
    private static String[] columnNames;
    private Comparator<Symbol> tableSortComparator;
    private final ArrayList<Comparator<Symbol>> tableSortingComparators = new ArrayList<Comparator>(Arrays.asList(new LabelAddressAscendingComparator(), new DescendingComparator(new LabelAddressAscendingComparator()), new LabelAddressAscendingComparator(), new DescendingComparator(new LabelAddressAscendingComparator()), new LabelNameAscendingComparator(), new LabelNameAscendingComparator(), new DescendingComparator(new LabelNameAscendingComparator()), new DescendingComparator(new LabelNameAscendingComparator())));
    private static final int[][] sortStateTransitions;
    private static final char ASCENDING_SYMBOL = '\u25b2';
    private static final char DESCENDING_SYMBOL = '\u25bc';
    private static final String[][] sortColumnHeadings;
    private int sortState = 0;

    public LabelsWindow() {
        super("Labels", true, false, true, true);
        try {
            this.sortState = Integer.parseInt(Globals.getSettings().getLabelSortState());
        }
        catch (NumberFormatException numberFormatException) {
            this.sortState = 0;
        }
        columnNames = sortColumnHeadings[this.sortState];
        this.tableSortComparator = this.tableSortingComparators.get(this.sortState);
        this.labelsWindow = this;
        this.contentPane = this.getContentPane();
        this.labelPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        JPanel jPanel = new JPanel();
        this.dataLabels = new JCheckBox("Data", true);
        this.textLabels = new JCheckBox("Text", true);
        this.dataLabels.addItemListener(new LabelItemListener());
        this.textLabels.addItemListener(new LabelItemListener());
        this.dataLabels.setToolTipText("If checked, will display labels defined in data segment");
        this.textLabels.setToolTipText("If checked, will display labels defined in text segment");
        jPanel.add(this.dataLabels);
        jPanel.add(this.textLabels);
        this.contentPane.add((Component)jPanel, "South");
        this.contentPane.add(this.labelPanel);
    }

    public void setupTable() {
        this.labelPanel.removeAll();
        this.labelPanel.add(this.generateLabelScrollPane());
    }

    public void clearWindow() {
        this.labelPanel.removeAll();
    }

    /*
     * WARNING - void declaration
     */
    private JScrollPane generateLabelScrollPane() {
        void var3_5;
        Object object;
        this.listOfLabelsForSymbolTable = new ArrayList();
        this.listOfLabelsForSymbolTable.add(new LabelsForSymbolTable(null));
        Box box = Box.createVerticalBox();
        for (RISCVprogram object32 : RunAssembleAction.getProgramsToAssemble()) {
            this.listOfLabelsForSymbolTable.add(new LabelsForSymbolTable(object32));
        }
        ArrayList arrayList = new ArrayList();
        Object var3_4 = null;
        for (LabelsForSymbolTable labelsForSymbolTable : this.listOfLabelsForSymbolTable) {
            if (!labelsForSymbolTable.hasSymbols()) continue;
            object = labelsForSymbolTable.getSymbolTableName();
            if (((String)object).length() > 24) {
                object = ((String)object).substring(0, 21) + "...";
            }
            JLabel jLabel = new JLabel((String)object, 2);
            Box box2 = Box.createHorizontalBox();
            box2.add(jLabel);
            box2.add(Box.createHorizontalGlue());
            box2.add(Box.createHorizontalStrut(1));
            arrayList.add(box2);
            box.add(box2);
            JTable jTable = labelsForSymbolTable.generateLabelTable();
            JTableHeader jTableHeader = jTable.getTableHeader();
            jTableHeader.setReorderingAllowed(false);
            jTable.setSelectionBackground(jTable.getBackground());
            jTable.addMouseListener(new LabelDisplayMouseListener());
            box.add(jTable);
        }
        JScrollPane jScrollPane = new JScrollPane(box, 22, 30);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (Box)iterator.next();
            ((JComponent)object).setMaximumSize(new Dimension(jScrollPane.getViewport().getViewSize().width, (int)(1.5 * (double)((JComponent)object).getFontMetrics(((Component)object).getFont()).getHeight())));
        }
        jScrollPane.setColumnHeaderView((Component)var3_5);
        return jScrollPane;
    }

    public void updateLabelAddresses() {
        if (this.listOfLabelsForSymbolTable != null) {
            for (LabelsForSymbolTable labelsForSymbolTable : this.listOfLabelsForSymbolTable) {
                labelsForSymbolTable.updateLabelAddresses();
            }
        }
    }

    static {
        sortStateTransitions = new int[][]{{4, 1}, {5, 0}, {6, 3}, {7, 2}, {6, 0}, {7, 1}, {4, 2}, {5, 3}};
        sortColumnHeadings = new String[][]{{"Label", "Address  \u25b2"}, {"Label", "Address  \u25bc"}, {"Label", "Address  \u25b2"}, {"Label", "Address  \u25bc"}, {"Label  \u25b2", "Address"}, {"Label  \u25b2", "Address"}, {"Label  \u25bc", "Address"}, {"Label  \u25bc", "Address"}};
    }

    private class LabelAddressAscendingComparator
    implements Comparator<Symbol> {
        private LabelAddressAscendingComparator() {
        }

        @Override
        public int compare(Symbol symbol, Symbol symbol2) {
            int n = symbol.getAddress();
            int n2 = symbol2.getAddress();
            return n >= 0 && n2 >= 0 || n < 0 && n2 < 0 ? n - n2 : n2;
        }
    }

    private class DescendingComparator
    implements Comparator<Symbol> {
        private Comparator<Symbol> opposite;

        private DescendingComparator(Comparator<Symbol> comparator) {
            this.opposite = comparator;
        }

        @Override
        public int compare(Symbol symbol, Symbol symbol2) {
            return this.opposite.compare(symbol2, symbol);
        }
    }

    private class LabelNameAscendingComparator
    implements Comparator<Symbol> {
        private LabelNameAscendingComparator() {
        }

        @Override
        public int compare(Symbol symbol, Symbol symbol2) {
            return symbol.getName().toLowerCase().compareTo(symbol2.getName().toLowerCase());
        }
    }

    private class LabelItemListener
    implements ItemListener {
        private LabelItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            for (LabelsForSymbolTable labelsForSymbolTable : LabelsWindow.this.listOfLabelsForSymbolTable) {
                labelsForSymbolTable.generateLabelTable();
            }
        }
    }

    private class LabelsForSymbolTable {
        private RISCVprogram program;
        private Object[][] labelData;
        private JTable labelTable;
        private ArrayList<Symbol> symbols;
        private SymbolTable symbolTable;
        private String tableName;

        public LabelsForSymbolTable(RISCVprogram rISCVprogram) {
            this.program = rISCVprogram;
            this.symbolTable = rISCVprogram == null ? Globals.symbolTable : rISCVprogram.getLocalSymbolTable();
            this.tableName = rISCVprogram == null ? "(global)" : new File(rISCVprogram.getFilename()).getName();
        }

        public String getSymbolTableName() {
            return this.tableName;
        }

        public boolean hasSymbols() {
            return this.symbolTable.getSize() != 0;
        }

        private JTable generateLabelTable() {
            SymbolTable symbolTable = this.program == null ? Globals.symbolTable : this.program.getLocalSymbolTable();
            int n = Globals.getGui().getMainPane().getExecutePane().getAddressDisplayBase();
            this.symbols = LabelsWindow.this.textLabels.isSelected() && LabelsWindow.this.dataLabels.isSelected() ? symbolTable.getAllSymbols() : (LabelsWindow.this.textLabels.isSelected() && !LabelsWindow.this.dataLabels.isSelected() ? symbolTable.getTextSymbols() : (!LabelsWindow.this.textLabels.isSelected() && LabelsWindow.this.dataLabels.isSelected() ? symbolTable.getDataSymbols() : new ArrayList()));
            Collections.sort(this.symbols, LabelsWindow.this.tableSortComparator);
            this.labelData = new Object[this.symbols.size()][2];
            for (int i = 0; i < this.symbols.size(); ++i) {
                Symbol symbol = this.symbols.get(i);
                this.labelData[i][0] = symbol.getName();
                this.labelData[i][1] = NumberDisplayBaseChooser.formatNumber(symbol.getAddress(), n);
            }
            LabelTableModel labelTableModel = new LabelTableModel(this.labelData, columnNames);
            if (this.labelTable == null) {
                this.labelTable = new MyTippedJTable(labelTableModel);
            } else {
                this.labelTable.setModel(labelTableModel);
            }
            this.labelTable.getColumnModel().getColumn(1).setCellRenderer(new MonoRightCellRenderer());
            return this.labelTable;
        }

        public void updateLabelAddresses() {
            if (LabelsWindow.this.labelPanel.getComponentCount() == 0) {
                return;
            }
            int n = Globals.getGui().getMainPane().getExecutePane().getAddressDisplayBase();
            int n2 = this.labelData == null ? 0 : this.labelData.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = this.symbols.get(i).getAddress();
                String string = NumberDisplayBaseChooser.formatNumber(n3, n);
                this.labelTable.getModel().setValueAt(string, i, 1);
            }
        }
    }

    private class LabelDisplayMouseListener
    extends MouseAdapter {
        private LabelDisplayMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
            Object object = jTable.getValueAt(n, n2);
            if (jTable.getColumnName(n2).equals(columnNames[0])) {
                object = jTable.getModel().getValueAt(n, 1);
            }
            int n3 = 0;
            try {
                n3 = Binary.stringToInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (Memory.inTextSegment(n3)) {
                Globals.getGui().getMainPane().getExecutePane().getTextSegmentWindow().selectStepAtAddress(n3);
            } else {
                Globals.getGui().getMainPane().getExecutePane().getDataSegmentWindow().selectCellForAddress(n3);
            }
        }
    }

    private class MyTippedJTable
    extends JTable {
        MyTippedJTable(LabelTableModel labelTableModel) {
            super(labelTableModel);
        }

        @Override
        protected JTableHeader createDefaultTableHeader() {
            return new SymbolTableHeader(this.columnModel);
        }

        @Override
        public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
            Component component = super.prepareRenderer(tableCellRenderer, n, n2);
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                jComponent.setToolTipText("Click on label or address to view it in Text/Data Segment");
            }
            return component;
        }

        private class SymbolTableHeader
        extends JTableHeader {
            public SymbolTableHeader(TableColumnModel tableColumnModel) {
                super(tableColumnModel);
                this.addMouseListener(new SymbolTableHeaderMouseListener());
            }

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.columnModel.getColumnIndexAtX(point.x);
                int n2 = this.columnModel.getColumn(n).getModelIndex();
                return columnToolTips[n2];
            }

            private class SymbolTableHeaderMouseListener
            implements MouseListener {
                private SymbolTableHeaderMouseListener() {
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    int n = SymbolTableHeader.this.columnModel.getColumnIndexAtX(point.x);
                    int n2 = SymbolTableHeader.this.columnModel.getColumn(n).getModelIndex();
                    LabelsWindow.this.sortState = sortStateTransitions[LabelsWindow.this.sortState][n2];
                    LabelsWindow.this.tableSortComparator = LabelsWindow.this.tableSortingComparators.get(LabelsWindow.this.sortState);
                    columnNames = sortColumnHeadings[LabelsWindow.this.sortState];
                    Globals.getSettings().setLabelSortState(Integer.toString(LabelsWindow.this.sortState));
                    LabelsWindow.this.setupTable();
                    Globals.getGui().getMainPane().getExecutePane().setLabelWindowVisibility(false);
                    Globals.getGui().getMainPane().getExecutePane().setLabelWindowVisibility(true);
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                }
            }
        }
    }

    class LabelTableModel
    extends AbstractTableModel {
        String[] columns;
        Object[][] data;

        public LabelTableModel(Object[][] objectArray, String[] stringArray) {
            this.data = objectArray;
            this.columns = stringArray;
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columns[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }

        private void printDebugData() {
            int n = this.getRowCount();
            int n2 = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < n2; ++j) {
                    System.out.print("  " + this.data[i][j]);
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }
}

