/*
 * Decompiled with CFR 0.152.
 */
package rars.venus;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import rars.Globals;
import rars.riscv.dump.DumpFormat;
import rars.riscv.dump.DumpFormatLoader;
import rars.riscv.hardware.AddressErrorException;
import rars.util.Binary;
import rars.util.MemoryDump;
import rars.venus.GuiAction;
import rars.venus.VenusUI;

public class FileDumpMemoryAction
extends GuiAction {
    private JDialog dumpDialog;
    private static final String title = "Dump Memory To File";
    private String[] segmentArray;
    private int[] baseAddressArray;
    private int[] limitAddressArray;
    private int[] highAddressArray;
    private String[] segmentListArray;
    private int[] segmentListBaseArray;
    private int[] segmentListHighArray;
    private JComboBox<String> segmentListSelector;
    private JComboBox formatListSelector;
    private VenusUI mainUI;

    public FileDumpMemoryAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke, VenusUI venusUI) {
        super(string, icon, string2, n, keyStroke);
        this.mainUI = venusUI;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.dumpMemory();
    }

    private void dumpMemory() {
        this.dumpDialog = this.createDumpDialog();
        this.dumpDialog.pack();
        this.dumpDialog.setLocationRelativeTo(Globals.getGui());
        this.dumpDialog.setVisible(true);
    }

    private JDialog createDumpDialog() {
        JDialog jDialog = new JDialog(Globals.getGui(), title, true);
        jDialog.setContentPane(this.buildDialogPanel());
        jDialog.setDefaultCloseOperation(0);
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                FileDumpMemoryAction.this.closeDialog();
            }
        });
        return jDialog;
    }

    private JPanel buildDialogPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(20, 20));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.segmentArray = MemoryDump.getSegmentNames();
        this.baseAddressArray = MemoryDump.getBaseAddresses(this.segmentArray);
        this.limitAddressArray = MemoryDump.getLimitAddresses(this.segmentArray);
        this.highAddressArray = new int[this.segmentArray.length];
        this.segmentListArray = new String[this.segmentArray.length];
        this.segmentListBaseArray = new int[this.segmentArray.length];
        this.segmentListHighArray = new int[this.segmentArray.length];
        int n = 0;
        for (int i = 0; i < this.segmentArray.length; ++i) {
            try {
                this.highAddressArray[i] = Globals.memory.getAddressOfFirstNull(this.baseAddressArray[i], this.limitAddressArray[i]) - 4;
            }
            catch (AddressErrorException addressErrorException) {
                this.highAddressArray[i] = this.baseAddressArray[i] - 4;
            }
            if (this.highAddressArray[i] < this.baseAddressArray[i]) continue;
            this.segmentListBaseArray[n] = this.baseAddressArray[i];
            this.segmentListHighArray[n] = this.highAddressArray[i];
            this.segmentListArray[n] = this.segmentArray[i] + " (" + Binary.intToHexString(this.baseAddressArray[i]) + " - " + Binary.intToHexString(this.highAddressArray[i]) + ")";
            ++n;
        }
        if (n == 0) {
            jPanel.add((Component)new Label("There is nothing to dump!"), "North");
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FileDumpMemoryAction.this.closeDialog();
                }
            });
            jPanel.add((Component)jButton, "South");
            return jPanel;
        }
        if (n < this.segmentListArray.length) {
            String[] stringArray = new String[n];
            System.arraycopy(this.segmentListArray, 0, stringArray, 0, n);
            this.segmentListArray = stringArray;
        }
        this.segmentListSelector = new JComboBox<String>(this.segmentListArray);
        this.segmentListSelector.setSelectedIndex(0);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new Label("Memory Segment"), "North");
        jPanel2.add(this.segmentListSelector);
        jPanel.add((Component)jPanel2, "West");
        ArrayList<DumpFormat> arrayList = DumpFormatLoader.getDumpFormats();
        this.formatListSelector = new JComboBox<Object>(arrayList.toArray());
        this.formatListSelector.setRenderer(new DumpFormatComboBoxRenderer(this.formatListSelector));
        this.formatListSelector.setSelectedIndex(0);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new Label("Dump Format"), "North");
        jPanel3.add(this.formatListSelector);
        jPanel.add((Component)jPanel3, "East");
        Box box = Box.createHorizontalBox();
        JButton jButton = new JButton("Dump To File...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FileDumpMemoryAction.this.performDump(FileDumpMemoryAction.this.segmentListBaseArray[FileDumpMemoryAction.this.segmentListSelector.getSelectedIndex()], FileDumpMemoryAction.this.segmentListHighArray[FileDumpMemoryAction.this.segmentListSelector.getSelectedIndex()], (DumpFormat)FileDumpMemoryAction.this.formatListSelector.getSelectedItem())) {
                    FileDumpMemoryAction.this.closeDialog();
                }
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileDumpMemoryAction.this.closeDialog();
            }
        });
        box.add(Box.createHorizontalGlue());
        box.add(jButton);
        box.add(Box.createHorizontalGlue());
        box.add(jButton2);
        box.add(Box.createHorizontalGlue());
        jPanel.add((Component)box, "South");
        return jPanel;
    }

    private boolean performDump(int n, int n2, DumpFormat dumpFormat) {
        boolean bl = false;
        JFileChooser jFileChooser = new JFileChooser(this.mainUI.getEditor().getCurrentSaveDirectory());
        jFileChooser.setDialogTitle(title);
        while (!bl) {
            int n3 = jFileChooser.showSaveDialog(this.mainUI);
            if (n3 != 0) {
                return false;
            }
            File file = jFileChooser.getSelectedFile();
            bl = true;
            if (file.exists()) {
                int n4 = JOptionPane.showConfirmDialog(this.mainUI, "File " + file.getName() + " already exists.  Do you wish to overwrite it?", "Overwrite existing file?", 1, 2);
                switch (n4) {
                    case 0: {
                        bl = true;
                        break;
                    }
                    case 1: {
                        bl = false;
                        break;
                    }
                    case 2: {
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (!bl) continue;
            try {
                dumpFormat.dumpMemoryRange(file, n, n2, Globals.memory);
            }
            catch (AddressErrorException addressErrorException) {
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    private void closeDialog() {
        this.dumpDialog.setVisible(false);
        this.dumpDialog.dispose();
    }

    private class DumpFormatComboBoxRenderer
    extends BasicComboBoxRenderer {
        private JComboBox myMaster;

        public DumpFormatComboBoxRenderer(JComboBox jComboBox) {
            this.myMaster = jComboBox;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setToolTipText(object.toString());
            if (n >= 0 && ((DumpFormat)this.myMaster.getItemAt(n)).getDescription() != null) {
                this.setToolTipText(((DumpFormat)this.myMaster.getItemAt(n)).getDescription());
            }
            return this;
        }
    }
}

