/*
 * Decompiled with CFR 0.152.
 */
package rars.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import rars.Globals;
import rars.Settings;

public class SystemIO {
    public static final int SYSCALL_BUFSIZE = 128;
    public static final int SYSCALL_MAXFILES = 32;
    public static String fileErrorString = new String("File operation OK");
    private static final int O_RDONLY = 0;
    private static final int O_WRONLY = 1;
    private static final int O_RDWR = 2;
    private static final int O_APPEND = 8;
    private static final int O_CREAT = 512;
    private static final int O_TRUNC = 1024;
    private static final int O_EXCL = 2048;
    private static final int SEEK_SET = 0;
    private static final int SEEK_CUR = 1;
    private static final int SEEK_END = 2;
    private static final int STDIN = 0;
    private static final int STDOUT = 1;
    private static final int STDERR = 2;
    private static String buffer = "";
    private static long lasttime = 0L;

    public static int readInteger(int n) {
        String string = SystemIO.readStringInternal("0", "Enter an integer value (syscall " + n + ")", -1);
        return Integer.parseInt(string.trim());
    }

    private static String readStringInternal(String string, String string2, int n) {
        String string3 = string;
        if (Globals.getGui() == null) {
            try {
                string3 = SystemIO.getInputReader().readLine();
                if (string3 == null) {
                    string3 = "";
                }
            }
            catch (IOException iOException) {}
        } else {
            string3 = Globals.getSettings().getBooleanSetting(Settings.Bool.POPUP_SYSCALL_INPUT) ? Globals.getGui().getMessagesPane().getInputString(string2) : Globals.getGui().getMessagesPane().getInputString(n);
        }
        return string3;
    }

    public static float readFloat(int n) {
        String string = SystemIO.readStringInternal("0", "Enter a float value (syscall " + n + ")", -1);
        return Float.parseFloat(string.trim());
    }

    public static double readDouble(int n) {
        String string = SystemIO.readStringInternal("0", "Enter a Double value (syscall " + n + ")", -1);
        return Double.parseDouble(string.trim());
    }

    public static void printString(String string) {
        if (Globals.getGui() == null) {
            try {
                SystemIO.getOutputWriter().write(string);
                SystemIO.getOutputWriter().flush();
            }
            catch (IOException iOException) {}
        } else {
            SystemIO.print2Gui(string);
        }
    }

    public static String readString(int n, int n2) {
        String string = SystemIO.readStringInternal("", "Enter a string of maximum length " + n2 + " (syscall " + n + ")", n2);
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() > n2) {
            return n2 <= 0 ? "" : string.substring(0, n2);
        }
        return string;
    }

    public static int readChar(int n) {
        char c = '\u0000';
        String string = SystemIO.readStringInternal("0", "Enter a character value (syscall " + n + ")", 1);
        c = string.charAt(0);
        return c;
    }

    public static int writeToFile(int n, byte[] byArray, int n2) {
        if ((n == 1 || n == 2) && Globals.getGui() != null) {
            String string = new String(byArray, StandardCharsets.UTF_8);
            SystemIO.print2Gui(string);
            return byArray.length;
        }
        if (!FileIOData.fdInUse(n, 1)) {
            fileErrorString = "File descriptor " + n + " is not open for writing";
            return -1;
        }
        OutputStream outputStream = (OutputStream)FileIOData.getStreamInUse(n);
        try {
            for (int i = 0; i < n2; ++i) {
                outputStream.write(byArray[i]);
            }
            outputStream.flush();
        }
        catch (IOException iOException) {
            fileErrorString = "IO Exception on write of file with fd " + n;
            return -1;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            fileErrorString = "IndexOutOfBoundsException on write of file with fd" + n;
            return -1;
        }
        return n2;
    }

    public static int readFromFile(int n, byte[] byArray, int n2) {
        int n3 = -1;
        if (n == 0 && Globals.getGui() != null) {
            String string = Globals.getGui().getMessagesPane().getInputString(n2);
            byte[] byArray2 = string.getBytes();
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = i < byArray2.length ? byArray2[i] : (byte)0;
            }
            return Math.min(byArray.length, byArray2.length);
        }
        if (!FileIOData.fdInUse(n, 0)) {
            fileErrorString = "File descriptor " + n + " is not open for reading";
            return -1;
        }
        InputStream inputStream = (InputStream)FileIOData.getStreamInUse(n);
        try {
            n3 = inputStream.read(byArray, 0, n2);
            if (n3 == -1) {
                n3 = 0;
            }
        }
        catch (IOException iOException) {
            fileErrorString = "IO Exception on read of file with fd " + n;
            return -1;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            fileErrorString = "IndexOutOfBoundsException on read of file with fd" + n;
            return -1;
        }
        return n3;
    }

    public static int seek(int n, int n2, int n3) {
        if (!FileIOData.fdInUse(n, 0)) {
            fileErrorString = "File descriptor " + n + " is not open for reading";
            return -1;
        }
        if (n < 0 || n >= 32) {
            return -1;
        }
        Closeable closeable = FileIOData.getStreamInUse(n);
        if (closeable == null) {
            return -1;
        }
        try {
            FileChannel fileChannel;
            if (closeable instanceof FileInputStream) {
                fileChannel = ((FileInputStream)closeable).getChannel();
            } else if (closeable instanceof FileOutputStream) {
                fileChannel = ((FileOutputStream)closeable).getChannel();
            } else {
                return -1;
            }
            if (n3 == 0) {
                n2 += 0;
            } else if (n3 == 1) {
                n2 = (int)((long)n2 + fileChannel.position());
            } else if (n3 == 2) {
                n2 = (int)((long)n2 + fileChannel.size());
            } else {
                return -1;
            }
            if (n2 < 0) {
                return -1;
            }
            fileChannel.position(n2);
            return n2;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public static int openFile(String string, int n) {
        int n2;
        int n3 = -1;
        n3 = n2 = FileIOData.nowOpening(string, n);
        if (n2 < 0) {
            return -1;
        }
        File file = new File(string);
        if (!file.isAbsolute() && Globals.program != null && Globals.getSettings().getBooleanSetting(Settings.Bool.DERIVE_CURRENT_WORKING_DIRECTORY)) {
            String string2 = new File(Globals.program.getFilename()).getParent();
            file = new File(string2, string);
        }
        if (n == 0) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                FileIOData.setStreamInUse(n2, fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileErrorString = "File " + string + " not found, open for input.";
                n3 = -1;
            }
        } else if ((n & 1) != 0) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file, (n & 8) != 0);
                FileIOData.setStreamInUse(n2, fileOutputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileErrorString = "File " + string + " not found, open for output.";
                n3 = -1;
            }
        }
        return n3;
    }

    public static void closeFile(int n) {
        FileIOData.close(n);
    }

    public static void resetFiles() {
        FileIOData.resetFiles();
    }

    public static String getFileErrorMessage() {
        return fileErrorString;
    }

    private static BufferedReader getInputReader() {
        if (FileIOData.inputReader == null) {
            FileIOData.inputReader = new BufferedReader(new InputStreamReader(System.in));
        }
        return FileIOData.inputReader;
    }

    private static BufferedWriter getOutputWriter() {
        if (FileIOData.outputWriter == null) {
            FileIOData.outputWriter = new BufferedWriter(new OutputStreamWriter(System.out));
        }
        return FileIOData.outputWriter;
    }

    private static void print2Gui(String string) {
        long l = System.currentTimeMillis();
        if (l > lasttime) {
            Globals.getGui().getMessagesPane().postRunMessage(buffer + string);
            buffer = "";
            lasttime = l + 100L;
        } else {
            buffer = buffer + string;
        }
    }

    public static void flush(boolean bl) {
        long l = System.currentTimeMillis();
        if (buffer != "" && (bl || l > lasttime)) {
            Globals.getGui().getMessagesPane().postRunMessage(buffer);
            buffer = "";
            lasttime = l + 100L;
        }
    }

    public static Data swapData(Data data) {
        Data data2 = new Data(false);
        data2.fileNames = FileIOData.fileNames;
        data2.fileFlags = FileIOData.fileFlags;
        data2.streams = FileIOData.streams;
        data2.inputReader = FileIOData.inputReader;
        data2.outputWriter = FileIOData.outputWriter;
        data2.errorWriter = FileIOData.errorWriter;
        FileIOData.fileNames = data.fileNames;
        FileIOData.fileFlags = data.fileFlags;
        FileIOData.streams = data.streams;
        FileIOData.inputReader = data.inputReader;
        FileIOData.outputWriter = data.outputWriter;
        FileIOData.errorWriter = data.errorWriter;
        return data2;
    }

    private static class FileIOData {
        private static String[] fileNames = new String[32];
        private static int[] fileFlags = new int[32];
        private static Closeable[] streams = new Closeable[32];
        public static BufferedReader inputReader;
        public static BufferedWriter outputWriter;
        public static BufferedWriter errorWriter;

        private FileIOData() {
        }

        private static void resetFiles() {
            for (int i = 0; i < 32; ++i) {
                FileIOData.close(i);
            }
            if (outputWriter != null) {
                try {
                    outputWriter.close();
                    outputWriter = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (errorWriter != null) {
                try {
                    errorWriter.close();
                    errorWriter = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            FileIOData.setupStdio();
        }

        private static void setupStdio() {
            FileIOData.fileNames[0] = "STDIN";
            FileIOData.fileNames[1] = "STDOUT";
            FileIOData.fileNames[2] = "STDERR";
            FileIOData.fileFlags[0] = 0;
            FileIOData.fileFlags[1] = 1;
            FileIOData.fileFlags[2] = 1;
            FileIOData.streams[0] = System.in;
            FileIOData.streams[1] = System.out;
            FileIOData.streams[2] = System.err;
            System.out.flush();
            System.err.flush();
        }

        private static void setStreamInUse(int n, Closeable closeable) {
            FileIOData.streams[n] = closeable;
        }

        private static Closeable getStreamInUse(int n) {
            return streams[n];
        }

        private static boolean filenameInUse(String string) {
            for (int i = 0; i < 32; ++i) {
                if (fileNames[i] == null || !fileNames[i].equals(string)) continue;
                return true;
            }
            return false;
        }

        private static boolean fdInUse(int n, int n2) {
            if (n < 0 || n >= 32) {
                return false;
            }
            if (fileNames[n] != null && fileFlags[n] == 0 && n2 == 0) {
                return true;
            }
            return fileNames[n] != null && (fileFlags[n] & n2 & 1) == 1;
        }

        private static void close(int n) {
            block6: {
                if (n <= 2 || n >= 32) {
                    return;
                }
                FileIOData.fileNames[n] = null;
                if (streams[n] != null) {
                    int n2 = fileFlags[n];
                    Closeable closeable = streams[n];
                    FileIOData.fileFlags[n] = -1;
                    FileIOData.streams[n] = null;
                    try {
                        if (n2 == 0) {
                            ((FileInputStream)closeable).close();
                            break block6;
                        }
                        ((FileOutputStream)closeable).close();
                    }
                    catch (IOException iOException) {}
                } else {
                    FileIOData.fileFlags[n] = -1;
                }
            }
        }

        private static int nowOpening(String string, int n) {
            int n2;
            if (FileIOData.filenameInUse(string)) {
                fileErrorString = "File name " + string + " is already open.";
                return -1;
            }
            if (n != 0 && n != 1 && n != 9) {
                fileErrorString = "File name " + string + " has unknown requested opening flag";
                return -1;
            }
            for (n2 = 0; fileNames[n2] != null && n2 < 32; ++n2) {
            }
            if (n2 >= 32) {
                fileErrorString = "File name " + string + " exceeds maximum open file limit of 32";
                return -1;
            }
            FileIOData.fileNames[n2] = new String(string);
            FileIOData.fileFlags[n2] = n;
            fileErrorString = new String("File operation OK");
            return n2;
        }
    }

    public static class Data {
        private String[] fileNames;
        private int[] fileFlags;
        public Closeable[] streams;
        public BufferedReader inputReader;
        public BufferedWriter outputWriter;
        public BufferedWriter errorWriter;

        public Data(boolean bl) {
            if (bl) {
                this.fileNames = new String[32];
                this.fileFlags = new int[32];
                this.streams = new Closeable[32];
                this.fileNames[0] = "STDIN";
                this.fileNames[1] = "STDOUT";
                this.fileNames[2] = "STDERR";
                this.fileFlags[0] = 0;
                this.fileFlags[1] = 1;
                this.fileFlags[2] = 1;
                this.streams[0] = System.in;
                this.streams[1] = System.out;
                this.streams[2] = System.err;
            }
        }

        public Data(ByteArrayInputStream byteArrayInputStream, ByteArrayOutputStream byteArrayOutputStream, ByteArrayOutputStream byteArrayOutputStream2) {
            this(true);
            this.streams[0] = byteArrayInputStream;
            this.streams[1] = byteArrayOutputStream;
            this.streams[2] = byteArrayOutputStream2;
            this.inputReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
            this.outputWriter = new BufferedWriter(new OutputStreamWriter(byteArrayOutputStream));
            this.errorWriter = new BufferedWriter(new OutputStreamWriter(byteArrayOutputStream2));
        }
    }
}

