/*
 * Decompiled with CFR 0.152.
 */
package rars.util;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import rars.Globals;

public class EditorFont {
    private static final String[] styleStrings = new String[]{"Plain", "Bold", "Italic", "Bold + Italic"};
    private static final int[] styleInts = new int[]{0, 1, 2, 3};
    public static final String DEFAULT_STYLE_STRING = styleStrings[0];
    public static final int DEFAULT_STYLE_INT = styleInts[0];
    public static final int MIN_SIZE = 6;
    public static final int MAX_SIZE = 72;
    public static final int DEFAULT_SIZE = 12;
    private static final String[] allCommonFamilies = new String[]{"Arial", "Courier New", "Georgia", "Lucida Sans Typewriter", "Times New Roman", "Verdana"};
    private static final String TAB_STRING = "\t";
    private static final char TAB_CHAR = '\t';
    private static final String SPACES = "                                                  ";
    private static final String[] commonFamilies = EditorFont.actualCommonFamilies();

    public static String[] getCommonFamilies() {
        return commonFamilies;
    }

    public static String[] getAllFamilies() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    public static String[] getFontStyleStrings() {
        return styleStrings;
    }

    public static int styleStringToStyleInt(String string) {
        String string2 = string.toLowerCase();
        for (int i = 0; i < styleStrings.length; ++i) {
            if (!string2.equals(styleStrings[i].toLowerCase())) continue;
            return styleInts[i];
        }
        return DEFAULT_STYLE_INT;
    }

    public static String styleIntToStyleString(int n) {
        for (int i = 0; i < styleInts.length; ++i) {
            if (n != styleInts[i]) continue;
            return styleStrings[i];
        }
        return DEFAULT_STYLE_STRING;
    }

    public static String sizeIntToSizeString(int n) {
        int n2 = n < 6 ? 6 : (n > 72 ? 72 : n);
        return String.valueOf(n2);
    }

    public static int sizeStringToSizeInt(String string) {
        int n = 12;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n < 6 ? 6 : (n > 72 ? 72 : n);
    }

    public static Font createFontFromStringValues(String string, String string2, String string3) {
        return new Font(string, EditorFont.styleStringToStyleInt(string2), EditorFont.sizeStringToSizeInt(string3));
    }

    public static String substituteSpacesForTabs(String string) {
        return EditorFont.substituteSpacesForTabs(string, Globals.getSettings().getEditorTabSize());
    }

    public static String substituteSpacesForTabs(String string, int n) {
        if (!string.contains(TAB_STRING)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != '\t') continue;
            stringBuffer.replace(i, i + 1, SPACES.substring(0, n - i % n));
        }
        return stringBuffer.toString();
    }

    private static String[] actualCommonFamilies() {
        String[] stringArray = new String[allCommonFamilies.length];
        Object[] objectArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Arrays.sort(objectArray);
        int n = 0;
        for (String string : allCommonFamilies) {
            if (Arrays.binarySearch(objectArray, string) < 0) continue;
            stringArray[n++] = string;
        }
        if (n < allCommonFamilies.length) {
            String[] stringArray2 = new String[n];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            stringArray = stringArray2;
        }
        return stringArray;
    }
}

