/*
 * Decompiled with CFR 0.152.
 */
package rars.tools;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import rars.Globals;
import rars.riscv.hardware.AccessNotice;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.ControlAndStatusRegisterFile;
import rars.riscv.hardware.InterruptController;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.MemoryAccessNotice;
import rars.tools.AbstractToolAndApplication;

public class TimerTool
extends AbstractToolAndApplication {
    private static String heading = "Timer Tool";
    private static String version = "Version 1.0 (Zachary Selk)";
    private static final int TIME_ADDRESS = Memory.memoryMapBaseAddress + 24;
    private static final int TIME_CMP_ADDRESS = Memory.memoryMapBaseAddress + 32;
    private static JPanel panelTools;
    private TimePanel timePanel;
    private static long time;
    private static long startTime;
    private static long savedTime;
    private static TimeCmpDaemon timeCmp;
    private Timer timer = new Timer();
    private Tick tick = new Tick();
    private static boolean updateTime;
    private static boolean running;

    public TimerTool() {
        super(heading + ", " + version, heading);
        this.startTimeCmpDaemon();
    }

    public TimerTool(String string, String string2) {
        super(string, string2);
        this.startTimeCmpDaemon();
    }

    public static void main(String[] stringArray) {
        new TimerTool(heading + ", " + version, heading);
    }

    @Override
    public String getName() {
        return "Timer Tool";
    }

    @Override
    protected JComponent buildMainDisplayArea() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        this.timePanel = new TimePanel();
        JButton jButton = new JButton("Play");
        jButton.setToolTipText("Starts the counter");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimerTool.this.play();
            }
        });
        jButton.addKeyListener(new AbstractToolAndApplication.EnterKeyListener(jButton));
        JButton jButton2 = new JButton("Pause");
        jButton2.setToolTipText("Pauses the counter");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimerTool.this.pause();
            }
        });
        jButton2.addKeyListener(new AbstractToolAndApplication.EnterKeyListener(jButton2));
        this.timePanel.add(jButton);
        this.timePanel.add(jButton2);
        jPanel.add(this.timePanel);
        return jPanel;
    }

    private void startTimeCmpDaemon() {
        if (timeCmp == null) {
            timeCmp = new TimeCmpDaemon();
        }
    }

    @Override
    protected void performSpecialClosingDuties() {
        this.stop();
    }

    public void start() {
        if (!running) {
            this.timer.schedule((TimerTask)this.tick, 0L, 1L);
            running = true;
        }
    }

    public void play() {
        if (!updateTime) {
            updateTime = true;
            startTime = System.currentTimeMillis();
        }
    }

    public void pause() {
        if (updateTime) {
            updateTime = false;
            savedTime = time = savedTime + System.currentTimeMillis() - startTime;
        }
    }

    @Override
    protected void reset() {
        time = 0L;
        savedTime = 0L;
        startTime = System.currentTimeMillis();
        this.tick.updateTimecmp = true;
        this.timePanel.updateTime();
        this.tick.reset();
    }

    public void stop() {
        updateTime = false;
        this.timer.cancel();
        running = false;
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateMMIOControlAndData(int n, int n2) {
        Globals.memoryAndRegistersLock.lock();
        try {
            try {
                Globals.memory.setRawWord(n, n2);
            }
            catch (AddressErrorException addressErrorException) {
                System.out.println("Tool author specified incorrect MMIO address!" + addressErrorException);
                System.exit(0);
            }
        }
        finally {
            Globals.memoryAndRegistersLock.unlock();
        }
    }

    @Override
    protected JComponent getHelpComponent() {
        JButton jButton = new JButton("Help");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTextArea jTextArea = new JTextArea("Use this tool to simulate the Memory Mapped IO (MMIO) for a timing device allowing the program to utalize timer interupts. While this tool is connected to the program it runs a clock (starting from time 0), storing the time in milliseconds. The time is stored as a 64 bit integer and can be accessed (using a lw instruction) at 0xFFFF0018 for the lower 32 bits and 0xFFFF001B for the upper 32 bits.\n\nThree things must be done before an interrupt can be set:\n The address of your interrupt handler must be stored in the utvec CSR\n The fourth bit of the uie CSR must be set to 1 (ie. ori uie, uie, 0x10)\n The zeroth bit of the ustatus CSR must be set to 1 (ie. ori ustatus, ustatus, 0x1)\nTo set the timer you must write the time that you want the timer to go off (called timecmp) as a 64 bit integer at the address of 0xFFFF0020 for the lower 32 bits and 0xFFFF0024 for the upper 32 bits. An interrupt will occur when the time is greater than or equal to timecmp which is a 64 bit integer (interpreted as milliseconds) stored at 0xFFFF0020 for the lower 32 bits and 0xFFFF0024 for the upper 32 bits. To set the timer you must set timecmp (using a sw instruction) to be the time that you want the timer to go off at.\n\nNote: the timer will only go off once after the time is reached and is not rearmed until timecmp is writen to again. So if you are writing 64 bit values (opposed to on 32) then to avoid spuriously triggering a timer interrupt timecmp should be written to as such\n    # a0: lower 32 bits of time\n    # a1: upper 32 bits of time\n    li  t0, -1\n    la t1, timecmp\n    sw t0, 0(t1)\n    sw a1, 4(t1)\n    sw a0, 0(t0)\n\n\n(contributed by Zachary Selk, zrselk@gmail.com)");
                jTextArea.setRows(20);
                jTextArea.setColumns(60);
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                JOptionPane.showMessageDialog(TimerTool.this.theWindow, new JScrollPane(jTextArea), "Simulating a timing device", 1);
            }
        });
        return jButton;
    }

    static {
        time = 0L;
        startTime = 0L;
        savedTime = 0L;
        timeCmp = null;
        updateTime = false;
        running = false;
    }

    private class Tick
    extends TimerTask {
        public volatile boolean updateTimecmp = true;

        private Tick() {
        }

        @Override
        public void run() {
            if (TimerTool.this.connectButton != null && TimerTool.this.connectButton.isConnected()) {
                if (updateTime) {
                    time = savedTime + System.currentTimeMillis() - startTime;
                    TimerTool.this.updateMMIOControlAndData(TIME_ADDRESS, (int)(time & 0xFFFFFFFFFFFFFFFFL));
                    TimerTool.this.updateMMIOControlAndData(TIME_ADDRESS + 4, (int)(time >> 32));
                    if (time >= TimerTool.timeCmp.value && TimerTool.timeCmp.postInterrupt && this.bitsEnabled()) {
                        InterruptController.registerTimerInterrupt(16);
                        TimerTool.timeCmp.postInterrupt = false;
                    }
                    TimerTool.this.timePanel.updateTime();
                }
            } else {
                time = savedTime + System.currentTimeMillis() - startTime;
                startTime = System.currentTimeMillis();
            }
        }

        private boolean bitsEnabled() {
            boolean bl = (ControlAndStatusRegisterFile.getValue("uie") & 0x10) == 16;
            boolean bl2 = (ControlAndStatusRegisterFile.getValue("ustatus") & 1) == 1;
            return bl && bl2;
        }

        public void reset() {
            TimerTool.this.updateMMIOControlAndData(TIME_ADDRESS, 0);
            TimerTool.this.updateMMIOControlAndData(TIME_ADDRESS + 4, 0);
        }
    }

    public class TimePanel
    extends JPanel {
        JLabel currentTime = new JLabel("Hello world");

        public TimePanel() {
            FlowLayout flowLayout = new FlowLayout();
            this.setLayout(flowLayout);
            this.add(this.currentTime);
            this.updateTime();
            TimerTool.this.start();
        }

        public void updateTime() {
            this.currentTime.setText(String.format("%02d:%02d.%02d", time / 60000L, time / 1000L % 60L, time % 100L));
        }
    }

    public class TimeCmpDaemon
    implements Observer {
        public boolean postInterrupt = false;
        public long value = 0L;

        public TimeCmpDaemon() {
            this.addAsObserver();
        }

        public void addAsObserver() {
            try {
                Globals.memory.addObserver(this, TIME_CMP_ADDRESS, TIME_CMP_ADDRESS + 8);
            }
            catch (AddressErrorException addressErrorException) {
                System.out.println("Error while adding observer in Timer Tool");
                System.exit(0);
            }
        }

        @Override
        public void update(Observable observable, Object object) {
            MemoryAccessNotice memoryAccessNotice = (MemoryAccessNotice)object;
            int n = ((AccessNotice)object).getAccessType();
            if (n == 1) {
                int n2 = memoryAccessNotice.getAddress();
                int n3 = memoryAccessNotice.getValue();
                if (n2 == TIME_CMP_ADDRESS) {
                    this.value = (this.value >> 32 << 32) + (long)n3;
                    this.postInterrupt = true;
                } else if (n2 == TIME_CMP_ADDRESS + 4) {
                    this.value = (this.value & 0xFFFFFFFFFFFFFFFFL) + ((long)n3 << 32);
                    this.postInterrupt = true;
                }
            }
        }
    }
}

