/*
 * Decompiled with CFR 0.152.
 */
package rars.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Observable;
import java.util.Random;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultCaret;
import rars.Globals;
import rars.riscv.hardware.AccessNotice;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.InterruptController;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.MemoryAccessNotice;
import rars.tools.AbstractToolAndApplication;
import rars.util.Binary;
import rars.venus.util.AbstractFontSettingDialog;

public class KeyboardAndDisplaySimulator
extends AbstractToolAndApplication {
    private static String version = "Version 1.4";
    private static String heading = "Keyboard and Display MMIO Simulator";
    private static String displayPanelTitle;
    private static String keyboardPanelTitle;
    private static char VT_FILL;
    public static Dimension preferredTextAreaDimension;
    private static Insets textAreaInsets;
    private final TransmitterDelayTechnique[] delayTechniques = new TransmitterDelayTechnique[]{new FixedLengthDelay(), new UniformlyDistributedDelay(), new NormallyDistributedDelay()};
    public static int RECEIVER_CONTROL;
    public static int RECEIVER_DATA;
    public static int TRANSMITTER_CONTROL;
    public static int TRANSMITTER_DATA;
    private boolean countingInstructions;
    private int instructionCount;
    private int transmitDelayInstructionCountLimit;
    private int currentDelayInstructionLimit;
    private int intWithCharacterToDisplay;
    private boolean displayAfterDelay = true;
    private boolean displayRandomAccessMode = false;
    private int rows;
    private int columns;
    private DisplayResizeAdapter updateDisplayBorder;
    private KeyboardAndDisplaySimulator simulator;
    private JPanel keyboardAndDisplay;
    private JScrollPane displayScrollPane;
    private JTextArea display;
    private JPanel displayPanel;
    private JPanel displayOptions;
    private JComboBox<TransmitterDelayTechnique> delayTechniqueChooser;
    private DelayLengthPanel delayLengthPanel;
    private JSlider delayLengthSlider;
    private JCheckBox displayAfterDelayCheckBox;
    private JPanel keyboardPanel;
    private JScrollPane keyAccepterScrollPane;
    private JTextArea keyEventAccepter;
    private JButton fontButton;
    private Font defaultFont = new Font("Monospaced", 0, 12);
    public static final int EXTERNAL_INTERRUPT_KEYBOARD = 64;
    public static final int EXTERNAL_INTERRUPT_DISPLAY = 128;
    private static final char CLEAR_SCREEN = '\f';
    private static final char SET_CURSOR_X_Y = '\u0007';

    public KeyboardAndDisplaySimulator(String string, String string2) {
        super(string, string2);
        this.simulator = this;
    }

    public KeyboardAndDisplaySimulator() {
        this(heading + ", " + version, heading);
    }

    public static void main(String[] stringArray) {
        new KeyboardAndDisplaySimulator(heading + " stand-alone, " + version, heading).go();
    }

    @Override
    public String getName() {
        return heading;
    }

    @Override
    protected void initializePreGUI() {
        RECEIVER_CONTROL = Memory.memoryMapBaseAddress;
        RECEIVER_DATA = Memory.memoryMapBaseAddress + 4;
        TRANSMITTER_CONTROL = Memory.memoryMapBaseAddress + 8;
        TRANSMITTER_DATA = Memory.memoryMapBaseAddress + 12;
        displayPanelTitle = "DISPLAY: Store to Transmitter Data " + Binary.intToHexString(TRANSMITTER_DATA);
        keyboardPanelTitle = "KEYBOARD: Characters typed here are stored to Receiver Data " + Binary.intToHexString(RECEIVER_DATA);
    }

    @Override
    protected void addAsObserver() {
        this.updateMMIOControl(TRANSMITTER_CONTROL, KeyboardAndDisplaySimulator.readyBitSet(TRANSMITTER_CONTROL));
        this.addAsObserver(RECEIVER_DATA, RECEIVER_DATA);
        this.addAsObserver(TRANSMITTER_DATA, TRANSMITTER_DATA);
        this.addAsObserver(Memory.textBaseAddress, Memory.textLimitAddress);
    }

    @Override
    protected JComponent buildMainDisplayArea() {
        this.keyboardAndDisplay = new JPanel(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(0, this.buildDisplay(), this.buildKeyboard());
        jSplitPane.setResizeWeight(0.5);
        this.keyboardAndDisplay.add(jSplitPane);
        return this.keyboardAndDisplay;
    }

    @Override
    protected void processRISCVUpdate(Observable observable, AccessNotice accessNotice) {
        MemoryAccessNotice memoryAccessNotice = (MemoryAccessNotice)accessNotice;
        if (memoryAccessNotice.getAddress() == RECEIVER_DATA && memoryAccessNotice.getAccessType() == 0) {
            this.updateMMIOControl(RECEIVER_CONTROL, KeyboardAndDisplaySimulator.readyBitCleared(RECEIVER_CONTROL));
        }
        if (KeyboardAndDisplaySimulator.isReadyBitSet(TRANSMITTER_CONTROL) && memoryAccessNotice.getAddress() == TRANSMITTER_DATA && memoryAccessNotice.getAccessType() == 1) {
            this.updateMMIOControl(TRANSMITTER_CONTROL, KeyboardAndDisplaySimulator.readyBitCleared(TRANSMITTER_CONTROL));
            this.intWithCharacterToDisplay = memoryAccessNotice.getValue();
            if (!this.displayAfterDelay) {
                this.displayCharacter(this.intWithCharacterToDisplay);
            }
            this.countingInstructions = true;
            this.instructionCount = 0;
            this.transmitDelayInstructionCountLimit = this.generateDelay();
        }
        if (this.countingInstructions && memoryAccessNotice.getAccessType() == 0 && Memory.inTextSegment(memoryAccessNotice.getAddress())) {
            ++this.instructionCount;
            if (this.instructionCount >= this.transmitDelayInstructionCountLimit) {
                if (this.displayAfterDelay) {
                    this.displayCharacter(this.intWithCharacterToDisplay);
                }
                this.countingInstructions = false;
                int n = KeyboardAndDisplaySimulator.readyBitSet(TRANSMITTER_CONTROL);
                this.updateMMIOControl(TRANSMITTER_CONTROL, n);
                if (n != 1) {
                    InterruptController.registerExternalInterrupt(128);
                }
            }
        }
    }

    private void displayCharacter(int n) {
        char c = (char)(n & 0xFF);
        if (c == '\f') {
            this.initializeDisplay(this.displayRandomAccessMode);
        } else if (c == '\u0007') {
            if (!this.displayRandomAccessMode) {
                this.displayRandomAccessMode = true;
                this.initializeDisplay(this.displayRandomAccessMode);
            }
            int n2 = (n & 0xFFF00000) >>> 20;
            int n3 = (n & 0xFFF00) >>> 8;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= this.columns) {
                n2 = this.columns - 1;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 >= this.rows) {
                n3 = this.rows - 1;
            }
            this.display.setCaretPosition(n3 * (this.columns + 1) + n2);
        } else if (this.displayRandomAccessMode) {
            try {
                int n4 = this.display.getCaretPosition();
                if ((n4 + 1) % (this.columns + 1) == 0) {
                    this.display.setCaretPosition(++n4);
                }
                this.display.replaceRange("" + c, n4, n4 + 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.display.setCaretPosition(this.display.getCaretPosition() - 1);
                this.display.replaceRange("" + c, this.display.getCaretPosition(), this.display.getCaretPosition() + 1);
            }
        } else {
            this.display.append("" + c);
        }
    }

    @Override
    protected void initializePostGUI() {
        this.initializeTransmitDelaySimulator();
        this.keyEventAccepter.requestFocusInWindow();
    }

    @Override
    protected void reset() {
        this.displayRandomAccessMode = false;
        this.initializeTransmitDelaySimulator();
        this.initializeDisplay(this.displayRandomAccessMode);
        this.keyEventAccepter.setText("");
        ((TitledBorder)this.displayPanel.getBorder()).setTitle(displayPanelTitle);
        this.displayPanel.repaint();
        this.keyEventAccepter.requestFocusInWindow();
        this.updateMMIOControl(TRANSMITTER_CONTROL, KeyboardAndDisplaySimulator.readyBitSet(TRANSMITTER_CONTROL));
    }

    private void initializeDisplay(boolean bl) {
        String string = "";
        if (bl) {
            Dimension dimension = this.getDisplayPanelTextDimensions();
            this.columns = (int)dimension.getWidth();
            this.rows = (int)dimension.getHeight();
            this.repaintDisplayPanelBorder();
            char[] cArray = new char[this.columns];
            Arrays.fill(cArray, VT_FILL);
            String string2 = new String(cArray);
            StringBuffer stringBuffer = new StringBuffer(string2);
            for (int i = 1; i < this.rows; ++i) {
                stringBuffer.append("\n" + string2);
            }
            string = stringBuffer.toString();
        }
        this.display.setText(string);
        this.display.setCaretPosition(0);
    }

    private void repaintDisplayPanelBorder() {
        Dimension dimension = this.getDisplayPanelTextDimensions();
        int n = (int)dimension.getWidth();
        int n2 = (int)dimension.getHeight();
        int n3 = this.display.getCaretPosition();
        String string = this.displayRandomAccessMode ? ((n3 + 1) % (this.columns + 1) != 0 ? "(" + n3 % (this.columns + 1) + "," + n3 / (this.columns + 1) + ")" : ((n3 + 1) % (this.columns + 1) == 0 && n3 / (this.columns + 1) + 1 == n2 ? "(" + (n3 % (this.columns + 1) - 1) + "," + n3 / (this.columns + 1) + ")" : "(0," + (n3 / (this.columns + 1) + 1) + ")")) : "" + n3;
        String string2 = displayPanelTitle + ", cursor " + string + ", area " + n + " x " + n2;
        ((TitledBorder)this.displayPanel.getBorder()).setTitle(string2);
        this.displayPanel.repaint();
    }

    private Dimension getDisplayPanelTextDimensions() {
        Dimension dimension = this.display.getSize();
        int n = (int)dimension.getWidth();
        int n2 = (int)dimension.getHeight();
        FontMetrics fontMetrics = this.getFontMetrics(this.display.getFont());
        int n3 = fontMetrics.getHeight();
        int n4 = fontMetrics.charWidth('m');
        return new Dimension(n / n4 - 1, n2 / n3 - 1);
    }

    @Override
    protected JComponent getHelpComponent() {
        final String string = "Keyboard And Display MMIO Simulator\n\nUse this program to simulate Memory-Mapped I/O (MMIO) for a keyboard input device and character display output device.  It may be run either from Tools menu or as a stand-alone application. For the latter, simply write a driver to instantiate a rars.tools.KeyboardAndDisplaySimulator object and invoke its go() method.\n\nWhile the tool is connected to the program, each keystroke in the text area causes the corresponding ASCII code to be placed in the Receiver Data register (low-order byte of memory word " + Binary.intToHexString(RECEIVER_DATA) + "), and the Ready bit to be set to 1 in the Receiver Control register (low-order bit of " + Binary.intToHexString(RECEIVER_CONTROL) + ").  The Ready bit is automatically reset to 0 when the program reads the Receiver Data using an 'lw' instruction.\n\nA program may write to the display area by detecting the Ready bit set (1) in the Transmitter Control register (low-order bit of memory word " + Binary.intToHexString(TRANSMITTER_CONTROL) + "), then storing the ASCII code of the character to be displayed in the Transmitter Data register (low-order byte of " + Binary.intToHexString(TRANSMITTER_DATA) + ") using a 'sw' instruction.  This triggers the simulated display to clear the Ready bit to 0, delay awhile to simulate processing the data, then set the Ready bit back to 1.  The delay is based on a count of executed instructions.\n\nIn a polled approach to I/O, a program idles in a loop, testing the device's Ready bit on each iteration until it is set to 1 before proceeding.  This tool also supports an interrupt-driven approach which requires the program to provide an interrupt handler but allows it to perform useful processing instead of idly looping.  When the device is ready, it signals an interrupt and the RARS simuator will transfer control to the interrupt handler. Interrupt-driven I/O is enabled when the program sets the Interrupt-Enable bit in the device's control register.  Details below.\n\nUpon setting the Receiver Controller's Ready bit to 1, its Interrupt-Enable bit (bit position 1) is tested. If 1, then an External Interrupt will be generated. The Interrupt-Enable bit is 0 by default and has to be set by the program if interrupt-driven input is desired.  Interrupt-driven input permits the program to perform useful tasks instead of idling in a loop polling the Receiver Ready bit!  Very event-oriented.  The Ready bit is supposed to be read-only but in RARS it is not.\n\nA similar test and potential response occurs when the Transmitter Controller's Ready bit is set to 1.  This occurs after the simulated delay described above.  The only difference that utval will have a different code.  This permits you to write programs that perform interrupt-driven output - the program can perform useful tasks while the output device is processing its data.  Much better than idling in a loop polling the Transmitter Ready bit! The Ready bit is supposed to be read-only but in RARS it is not.\n\nIMPORTANT NOTE: The Transmitter Controller Ready bit is set to its initial value of 1 only when you click the tool's 'Connect to Program' button ('Assemble and Run' in the stand-alone version) or the tool's Reset button!  If you run a program and reset it in RARS, the controller's Ready bit is cleared to 0!  Configure the Data Segment Window to display the MMIO address range so you can directly observe values stored in the MMIO addresses given above.\n\nClear the display window from the program:\n\nWhen ASCII 12 (form feed) is stored in the Transmitter Data register, the tool's Display window will be cleared following the specified transmission delay.\n\nSimulate a text-based virtual terminal with (x,y) positioning:\n\nWhen ASCII 7 (bell) is stored in the Transmitter Data register, the cursor in the tool's Display window will be positioned at the (X,Y) coordinate specified by its high-order 3 bytes, following the specfied transmission delay. Place the X position (column) in bit positions 20-31 of the Transmitter Data register and place the Y position (row) in bit positions 8-19.  The cursor is not displayed but subsequent transmitted characters will be displayed starting at that position. Position (0,0) is at upper left. Why did I select the ASCII Bell character?  Just for fun!\n\nThe dimensions (number of columns and rows) of the virtual text-based terminal are calculated based on the display window size and font specifications.  This calculation occurs during program execution upon first use of the ASCII 7 code. It will not change until the Reset button is clicked, even if the window is resized.  The window dimensions are included in its title, which will be updated upon window resize or font change.  No attempt is made to reposition data characters already transmitted by the program.  To change the dimensions of the virtual terminal, resize the Display window as desired (note there is an adjustible splitter between the Display and Keyboard windows) then click the tool's Reset button.  Implementation detail: the window is implemented by a JTextArea to which text is written as a string. Its caret (cursor) position is required to be a position within the string.  I simulated a text terminal with random positioning by pre-allocating a string of spaces with one space per (X,Y) position and an embedded newline where each line ends. Each character transmitted to the window thus replaces an existing character in the string.\n\nThanks to Eric Wang at Washington State University, who requested these features to enable use of this display as the target for programming MMIO text-based games.";
        JButton jButton = new JButton("Help");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTextArea jTextArea = new JTextArea(string);
                jTextArea.setRows(30);
                jTextArea.setColumns(60);
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                final JDialog jDialog = KeyboardAndDisplaySimulator.this.theWindow instanceof Dialog ? new JDialog((Dialog)KeyboardAndDisplaySimulator.this.theWindow, "Simulating the Keyboard and Display", false) : new JDialog((Frame)KeyboardAndDisplaySimulator.this.theWindow, "Simulating the Keyboard and Display", false);
                jDialog.setSize(jTextArea.getPreferredSize());
                jDialog.getContentPane().setLayout(new BorderLayout());
                jDialog.getContentPane().add((Component)new JScrollPane(jTextArea), "Center");
                JButton jButton = new JButton("Close");
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        jDialog.setVisible(false);
                        jDialog.dispose();
                    }
                });
                JPanel jPanel = new JPanel();
                jPanel.add(jButton);
                jDialog.getContentPane().add((Component)jPanel, "South");
                jDialog.setLocationRelativeTo(KeyboardAndDisplaySimulator.this.theWindow);
                jDialog.setVisible(true);
            }
        });
        return jButton;
    }

    private JComponent buildDisplay() {
        this.displayPanel = new JPanel(new BorderLayout());
        TitledBorder titledBorder = new TitledBorder(displayPanelTitle);
        titledBorder.setTitleJustification(2);
        this.displayPanel.setBorder(titledBorder);
        this.display = new JTextArea();
        this.display.setFont(this.defaultFont);
        this.display.setEditable(false);
        this.display.setMargin(textAreaInsets);
        this.updateDisplayBorder = new DisplayResizeAdapter();
        this.display.addComponentListener(this.updateDisplayBorder);
        this.display.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                KeyboardAndDisplaySimulator.this.simulator.repaintDisplayPanelBorder();
            }
        });
        DefaultCaret defaultCaret = (DefaultCaret)this.display.getCaret();
        defaultCaret.setUpdatePolicy(2);
        this.displayScrollPane = new JScrollPane(this.display);
        this.displayScrollPane.setPreferredSize(preferredTextAreaDimension);
        this.displayPanel.add(this.displayScrollPane);
        this.displayOptions = new JPanel();
        this.delayTechniqueChooser = new JComboBox<TransmitterDelayTechnique>(this.delayTechniques);
        this.delayTechniqueChooser.setToolTipText("Technique for determining simulated transmitter device processing delay");
        this.delayTechniqueChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardAndDisplaySimulator.this.transmitDelayInstructionCountLimit = KeyboardAndDisplaySimulator.this.generateDelay();
            }
        });
        this.delayLengthPanel = new DelayLengthPanel();
        this.displayAfterDelayCheckBox = new JCheckBox("DAD", true);
        this.displayAfterDelayCheckBox.setToolTipText("Display After Delay: if checked, transmitter data not displayed until after delay");
        this.displayAfterDelayCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardAndDisplaySimulator.this.displayAfterDelay = KeyboardAndDisplaySimulator.this.displayAfterDelayCheckBox.isSelected();
            }
        });
        this.fontButton = new JButton("Font");
        this.fontButton.setToolTipText("Select the font for the display panel");
        this.fontButton.addActionListener(new FontChanger());
        this.displayOptions.add(this.fontButton);
        this.displayOptions.add(this.displayAfterDelayCheckBox);
        this.displayOptions.add(this.delayTechniqueChooser);
        this.displayOptions.add(this.delayLengthPanel);
        this.displayPanel.add((Component)this.displayOptions, "South");
        return this.displayPanel;
    }

    private JComponent buildKeyboard() {
        this.keyboardPanel = new JPanel(new BorderLayout());
        this.keyEventAccepter = new JTextArea();
        this.keyEventAccepter.setEditable(true);
        this.keyEventAccepter.setFont(this.defaultFont);
        this.keyEventAccepter.setMargin(textAreaInsets);
        this.keyAccepterScrollPane = new JScrollPane(this.keyEventAccepter);
        this.keyAccepterScrollPane.setPreferredSize(preferredTextAreaDimension);
        this.keyEventAccepter.addKeyListener(new KeyboardKeyListener());
        this.keyboardPanel.add(this.keyAccepterScrollPane);
        TitledBorder titledBorder = new TitledBorder(keyboardPanelTitle);
        titledBorder.setTitleJustification(2);
        this.keyboardPanel.setBorder(titledBorder);
        return this.keyboardPanel;
    }

    private void updateMMIOControl(int n, int n2) {
        this.updateMMIOControlAndData(n, n2, 0, 0, true);
    }

    private void updateMMIOControlAndData(int n, int n2, int n3, int n4) {
        this.updateMMIOControlAndData(n, n2, n3, n4, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMMIOControlAndData(int n, int n2, int n3, int n4, boolean bl) {
        if (!this.isBeingUsedAsATool || this.isBeingUsedAsATool && this.connectButton.isConnected()) {
            Globals.memoryAndRegistersLock.lock();
            try {
                try {
                    Globals.memory.setRawWord(n, n2);
                    if (!bl) {
                        Globals.memory.setRawWord(n3, n4);
                    }
                }
                catch (AddressErrorException addressErrorException) {
                    System.out.println("Tool author specified incorrect MMIO address!" + addressErrorException);
                    System.exit(0);
                }
            }
            finally {
                Globals.memoryAndRegistersLock.unlock();
            }
            if (Globals.getGui() != null && Globals.getGui().getMainPane().getExecutePane().getTextSegmentWindow().getCodeHighlighting()) {
                Globals.getGui().getMainPane().getExecutePane().getDataSegmentWindow().updateValues();
            }
        }
    }

    private static boolean isReadyBitSet(int n) {
        try {
            return (Globals.memory.get(n, 4) & 1) == 1;
        }
        catch (AddressErrorException addressErrorException) {
            System.out.println("Tool author specified incorrect MMIO address!" + addressErrorException);
            System.exit(0);
            return false;
        }
    }

    private static int readyBitSet(int n) {
        try {
            return Globals.memory.get(n, 4) | 1;
        }
        catch (AddressErrorException addressErrorException) {
            System.out.println("Tool author specified incorrect MMIO address!" + addressErrorException);
            System.exit(0);
            return 1;
        }
    }

    private static int readyBitCleared(int n) {
        try {
            return Globals.memory.get(n, 4) & 2;
        }
        catch (AddressErrorException addressErrorException) {
            System.out.println("Tool author specified incorrect MMIO address!" + addressErrorException);
            System.exit(0);
            return 0;
        }
    }

    private void initializeTransmitDelaySimulator() {
        this.countingInstructions = false;
        this.instructionCount = 0;
        this.transmitDelayInstructionCountLimit = this.generateDelay();
    }

    private int generateDelay() {
        double d = this.delayLengthPanel.getDelayLength();
        TransmitterDelayTechnique transmitterDelayTechnique = (TransmitterDelayTechnique)this.delayTechniqueChooser.getSelectedItem();
        return transmitterDelayTechnique.generateDelay(d);
    }

    static {
        VT_FILL = (char)32;
        preferredTextAreaDimension = new Dimension(400, 200);
        textAreaInsets = new Insets(4, 4, 4, 4);
    }

    private static interface TransmitterDelayTechnique {
        public int generateDelay(double var1);
    }

    private class FixedLengthDelay
    implements TransmitterDelayTechnique {
        private FixedLengthDelay() {
        }

        public String toString() {
            return "Fixed transmitter delay, select using slider";
        }

        @Override
        public int generateDelay(double d) {
            return (int)d;
        }
    }

    private class UniformlyDistributedDelay
    implements TransmitterDelayTechnique {
        Random randu = new Random();

        public String toString() {
            return "Uniformly distributed delay, min=1, max=slider";
        }

        @Override
        public int generateDelay(double d) {
            return this.randu.nextInt((int)d) + 1;
        }
    }

    private class NormallyDistributedDelay
    implements TransmitterDelayTechnique {
        Random randn = new Random();

        public String toString() {
            return "'Normally' distributed delay: floor(abs(N(0,1)*slider)+1)";
        }

        @Override
        public int generateDelay(double d) {
            return (int)(Math.abs(this.randn.nextGaussian() * d) + 1.0);
        }
    }

    private class DisplayResizeAdapter
    extends ComponentAdapter {
        private DisplayResizeAdapter() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            KeyboardAndDisplaySimulator.this.getDisplayPanelTextDimensions();
            KeyboardAndDisplaySimulator.this.repaintDisplayPanelBorder();
        }
    }

    private class DelayLengthPanel
    extends JPanel {
        private static final int DELAY_INDEX_MIN = 0;
        private static final int DELAY_INDEX_MAX = 40;
        private static final int DELAY_INDEX_INIT = 4;
        private double[] delayTable;
        private JLabel sliderLabel;
        private volatile int delayLengthIndex;

        public DelayLengthPanel() {
            super(new BorderLayout());
            this.delayTable = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 10.0, 20.0, 30.0, 40.0, 50.0, 100.0, 150.0, 200.0, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0, 1000.0, 1500.0, 2000.0, 3000.0, 4000.0, 5000.0, 6000.0, 7000.0, 8000.0, 9000.0, 10000.0, 20000.0, 40000.0, 60000.0, 80000.0, 100000.0, 200000.0, 400000.0, 600000.0, 800000.0, 1000000.0};
            this.sliderLabel = null;
            this.delayLengthIndex = 4;
            KeyboardAndDisplaySimulator.this.delayLengthSlider = new JSlider(0, 0, 40, 4);
            KeyboardAndDisplaySimulator.this.delayLengthSlider.setSize(new Dimension(100, (int)KeyboardAndDisplaySimulator.this.delayLengthSlider.getSize().getHeight()));
            KeyboardAndDisplaySimulator.this.delayLengthSlider.setMaximumSize(KeyboardAndDisplaySimulator.this.delayLengthSlider.getSize());
            KeyboardAndDisplaySimulator.this.delayLengthSlider.addChangeListener(new DelayLengthListener());
            this.sliderLabel = new JLabel(this.setLabel(this.delayLengthIndex));
            this.sliderLabel.setHorizontalAlignment(0);
            this.sliderLabel.setAlignmentX(0.5f);
            this.add((Component)this.sliderLabel, "North");
            this.add((Component)KeyboardAndDisplaySimulator.this.delayLengthSlider, "Center");
            this.setToolTipText("Parameter for simulated delay length (instruction execution count)");
        }

        public double getDelayLength() {
            return this.delayTable[this.delayLengthIndex];
        }

        private String setLabel(int n) {
            return "Delay length: " + (int)this.delayTable[n] + " instruction executions";
        }

        private class DelayLengthListener
        implements ChangeListener {
            private DelayLengthListener() {
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (!jSlider.getValueIsAdjusting()) {
                    DelayLengthPanel.this.delayLengthIndex = jSlider.getValue();
                    KeyboardAndDisplaySimulator.this.transmitDelayInstructionCountLimit = KeyboardAndDisplaySimulator.this.generateDelay();
                } else {
                    DelayLengthPanel.this.sliderLabel.setText(DelayLengthPanel.this.setLabel(jSlider.getValue()));
                }
            }
        }
    }

    private class FontChanger
    implements ActionListener {
        private FontChanger() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            FontSettingDialog fontSettingDialog = new FontSettingDialog(null, "Select Text Font", KeyboardAndDisplaySimulator.this.display.getFont());
            Font font = fontSettingDialog.showDialog();
        }
    }

    private class KeyboardKeyListener
    implements KeyListener {
        private KeyboardKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            int n = KeyboardAndDisplaySimulator.readyBitSet(RECEIVER_CONTROL);
            KeyboardAndDisplaySimulator.this.updateMMIOControlAndData(RECEIVER_CONTROL, n, RECEIVER_DATA, keyEvent.getKeyChar() & 0xFF);
            if (n != 1) {
                InterruptController.registerExternalInterrupt(64);
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    private class FontSettingDialog
    extends AbstractFontSettingDialog {
        private boolean resultOK;

        public FontSettingDialog(Frame frame, String string, Font font) {
            super(frame, string, true, font);
        }

        private Font showDialog() {
            this.resultOK = true;
            this.setVisible(true);
            return this.resultOK ? this.getFont() : null;
        }

        @Override
        protected void closeDialog() {
            this.setVisible(false);
            KeyboardAndDisplaySimulator.this.updateDisplayBorder.componentResized(null);
        }

        private void performCancel() {
            this.resultOK = false;
        }

        @Override
        protected Component buildControlPanel() {
            Box box = Box.createHorizontalBox();
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FontSettingDialog.this.apply(FontSettingDialog.this.getFont());
                    FontSettingDialog.this.closeDialog();
                }
            });
            JButton jButton2 = new JButton("Cancel");
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FontSettingDialog.this.performCancel();
                    FontSettingDialog.this.closeDialog();
                }
            });
            JButton jButton3 = new JButton("Reset");
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FontSettingDialog.this.reset();
                }
            });
            box.add(Box.createHorizontalGlue());
            box.add(jButton);
            box.add(Box.createHorizontalGlue());
            box.add(jButton2);
            box.add(Box.createHorizontalGlue());
            box.add(jButton3);
            box.add(Box.createHorizontalGlue());
            return box;
        }

        @Override
        protected void apply(Font font) {
            KeyboardAndDisplaySimulator.this.display.setFont(font);
            KeyboardAndDisplaySimulator.this.keyEventAccepter.setFont(font);
        }
    }
}

