/*
 * Decompiled with CFR 0.152.
 */
package rars.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import rars.Globals;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.InterruptController;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.MemoryAccessNotice;
import rars.tools.AbstractToolAndApplication;
import rars.util.Binary;

public class DigitalLabSim
extends AbstractToolAndApplication {
    private static String heading = "Digital Lab Sim";
    private static String version = " Version 1.0 (Didier Teifreto)";
    private final int IN_ADRESS_DISPLAY_1 = Memory.memoryMapBaseAddress + 16;
    private final int IN_ADRESS_DISPLAY_2 = Memory.memoryMapBaseAddress + 17;
    private final int IN_ADRESS_HEXA_KEYBOARD = Memory.memoryMapBaseAddress + 18;
    private final int IN_ADRESS_COUNTER = Memory.memoryMapBaseAddress + 19;
    private final int OUT_ADRESS_HEXA_KEYBOARD = Memory.memoryMapBaseAddress + 20;
    public static final int EXTERNAL_INTERRUPT_TIMER = 256;
    public static final int EXTERNAL_INTERRUPT_HEXA_KEYBOARD = 512;
    private static JPanel panelTools;
    private SevenSegmentPanel sevenSegPanel;
    private static int KeyBoardValueButtonClick;
    private HexaKeyboard hexaKeyPanel;
    private static boolean KeyboardInterruptOnOff;
    private static int CounterValueMax;
    private static int CounterValue;
    private static boolean CounterInterruptOnOff;
    private static OneSecondCounter SecondCounter;

    public DigitalLabSim(String string, String string2) {
        super(string, string2);
    }

    public DigitalLabSim() {
        this(heading + ", " + version, heading);
    }

    public static void main(String[] stringArray) {
        new DigitalLabSim(heading + ", " + version, heading).go();
    }

    @Override
    public String getName() {
        return "Digital Lab Sim";
    }

    @Override
    protected void addAsObserver() {
        this.addAsObserver(this.IN_ADRESS_DISPLAY_1, this.IN_ADRESS_DISPLAY_1);
        this.addAsObserver(Memory.textBaseAddress, Memory.textLimitAddress);
    }

    @Override
    public void update(Observable observable, Object object) {
        MemoryAccessNotice memoryAccessNotice = (MemoryAccessNotice)object;
        int n = memoryAccessNotice.getAddress();
        char c = (char)memoryAccessNotice.getValue();
        if (n == this.IN_ADRESS_DISPLAY_1) {
            this.updateSevenSegment(1, c);
        } else if (n == this.IN_ADRESS_DISPLAY_2) {
            this.updateSevenSegment(0, c);
        } else if (n == this.IN_ADRESS_HEXA_KEYBOARD) {
            this.updateHexaKeyboard(c);
        } else if (n == this.IN_ADRESS_COUNTER) {
            this.updateOneSecondCounter(c);
        }
        if (CounterInterruptOnOff) {
            if (CounterValue > 0) {
                --CounterValue;
            } else {
                CounterValue = CounterValueMax;
                InterruptController.registerTimerInterrupt(256);
            }
        }
    }

    @Override
    protected void reset() {
        this.sevenSegPanel.resetSevenSegment();
        this.hexaKeyPanel.resetHexaKeyboard();
        SecondCounter.resetOneSecondCounter();
    }

    @Override
    protected JComponent buildMainDisplayArea() {
        panelTools = new JPanel(new GridLayout(1, 2));
        this.sevenSegPanel = new SevenSegmentPanel();
        panelTools.add(this.sevenSegPanel);
        this.hexaKeyPanel = new HexaKeyboard();
        panelTools.add(this.hexaKeyPanel);
        SecondCounter = new OneSecondCounter();
        return panelTools;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateMMIOControlAndData(int n, int n2) {
        if (!this.isBeingUsedAsATool || this.isBeingUsedAsATool && this.connectButton.isConnected()) {
            Globals.memoryAndRegistersLock.lock();
            try {
                try {
                    Globals.memory.setByte(n, n2);
                }
                catch (AddressErrorException addressErrorException) {
                    System.out.println("Tool author specified incorrect MMIO address!" + addressErrorException);
                    System.exit(0);
                }
            }
            finally {
                Globals.memoryAndRegistersLock.unlock();
            }
            if (Globals.getGui() != null && Globals.getGui().getMainPane().getExecutePane().getTextSegmentWindow().getCodeHighlighting()) {
                Globals.getGui().getMainPane().getExecutePane().getDataSegmentWindow().updateValues();
            }
        }
    }

    @Override
    protected JComponent getHelpComponent() {
        final String string = " This tool is composed of 3 parts : two seven-segment displays, an hexadecimal keyboard and counter \nSeven segment display\n Byte value at address " + Binary.intToHexString(this.IN_ADRESS_DISPLAY_1) + " : command right seven segment display \n  Byte value at address " + Binary.intToHexString(this.IN_ADRESS_DISPLAY_2) + " : command left seven segment display \n  Each bit of these two bytes are connected to segments (bit 0 for a segment, 1 for b segment and 7 for point \n \nHexadecimal keyboard\n Byte value at address " + Binary.intToHexString(this.IN_ADRESS_HEXA_KEYBOARD) + " : command row number of hexadecimal keyboard (bit 0 to 3) and enable keyboard interrupt (bit 7) \n Byte value at address " + Binary.intToHexString(this.OUT_ADRESS_HEXA_KEYBOARD) + " : receive row and column of the key pressed, 0 if not key pressed \n The program has to scan, one by one, each row (send 1,2,4,8...) and then observe if a key is pressed (that mean byte value at adresse 0xFFFF0014 is different from zero).  This byte value is composed of row number (4 left bits) and column number (4 right bits) Here you'll find the code for each key : 0x11,0x21,0x41,0x81,0x12,0x22,0x42,0x82,0x14,0x24,0x44,0x84,0x18,0x28,0x48,0x88. \n For exemple key number 2 return 0x41, that mean the key is on column 3 and row 1. \n If keyboard interruption is enable, an external interrupt is started with value 0x00000200\n \nCounter\n Byte value at address " + Binary.intToHexString(this.IN_ADRESS_COUNTER) + " : If one bit of this byte is set, the counter interruption is enabled.\n If counter interruption is enable, every 30 instructions, a timer interrupt is started with value 0x00000100.\n   (contributed by Didier Teifreto, dteifreto@lifc.univ-fcomte.fr)";
        JButton jButton = new JButton("Help");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTextArea jTextArea = new JTextArea(string);
                jTextArea.setRows(20);
                jTextArea.setColumns(60);
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                JOptionPane.showMessageDialog(DigitalLabSim.this.theWindow, new JScrollPane(jTextArea), "Simulating the Hexa Keyboard and Seven segment display", 1);
            }
        });
        return jButton;
    }

    public void updateSevenSegment(int n, char c) {
        this.sevenSegPanel.display[n].modifyDisplay(c);
    }

    public void updateHexaKeyboard(char c) {
        int n = KeyBoardValueButtonClick;
        if (n != -1 && 1 << n / 4 == (c & 0xF)) {
            this.updateMMIOControlAndData(this.OUT_ADRESS_HEXA_KEYBOARD, (char)(1 << n / 4) | 1 << 4 + n % 4);
        } else {
            this.updateMMIOControlAndData(this.OUT_ADRESS_HEXA_KEYBOARD, 0);
        }
        KeyboardInterruptOnOff = (c & 0xF0) != 0;
    }

    public void updateOneSecondCounter(char c) {
        if (c != '\u0000') {
            CounterInterruptOnOff = true;
            CounterValue = CounterValueMax;
        } else {
            CounterInterruptOnOff = false;
        }
    }

    static {
        KeyBoardValueButtonClick = -1;
        KeyboardInterruptOnOff = false;
        CounterValue = CounterValueMax = 30;
        CounterInterruptOnOff = false;
    }

    public class SevenSegmentPanel
    extends JPanel {
        public SevenSegmentDisplay[] display;

        public SevenSegmentPanel() {
            FlowLayout flowLayout = new FlowLayout();
            this.setLayout(flowLayout);
            this.display = new SevenSegmentDisplay[2];
            for (int i = 0; i < 2; ++i) {
                this.display[i] = new SevenSegmentDisplay('\u0000');
                this.add(this.display[i]);
            }
        }

        public void modifyDisplay(int n, char c) {
            this.display[n].modifyDisplay(c);
            this.display[n].repaint();
        }

        public void resetSevenSegment() {
            for (int i = 0; i < 2; ++i) {
                this.modifyDisplay(i, '\u0000');
            }
        }
    }

    public class HexaKeyboard
    extends JPanel {
        public JButton[] button;

        public HexaKeyboard() {
            GridLayout gridLayout = new GridLayout(4, 4);
            this.setLayout(gridLayout);
            this.button = new JButton[16];
            for (int i = 0; i < 16; ++i) {
                this.button[i] = new JButton(Integer.toHexString(i));
                this.button[i].setBackground(Color.WHITE);
                this.button[i].setMargin(new Insets(10, 10, 10, 10));
                this.button[i].addMouseListener(new EcouteurClick(i));
                this.add(this.button[i]);
            }
        }

        public void resetHexaKeyboard() {
            KeyBoardValueButtonClick = -1;
            for (int i = 0; i < 16; ++i) {
                this.button[i].setBackground(Color.WHITE);
            }
        }

        public class EcouteurClick
        implements MouseListener {
            private int buttonValue;

            public EcouteurClick(int n) {
                this.buttonValue = n;
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (KeyBoardValueButtonClick != -1) {
                    KeyBoardValueButtonClick = -1;
                    DigitalLabSim.this.updateMMIOControlAndData(DigitalLabSim.this.OUT_ADRESS_HEXA_KEYBOARD, 0);
                    for (int i = 0; i < 16; ++i) {
                        HexaKeyboard.this.button[i].setBackground(Color.WHITE);
                    }
                } else {
                    KeyBoardValueButtonClick = this.buttonValue;
                    HexaKeyboard.this.button[KeyBoardValueButtonClick].setBackground(Color.GREEN);
                    if (KeyboardInterruptOnOff) {
                        InterruptController.registerExternalInterrupt(512);
                    }
                }
            }
        }
    }

    public class OneSecondCounter {
        public OneSecondCounter() {
            CounterInterruptOnOff = false;
        }

        public void resetOneSecondCounter() {
            CounterInterruptOnOff = false;
            CounterValue = CounterValueMax;
        }
    }

    public class SevenSegmentDisplay
    extends JComponent {
        public char aff;

        public SevenSegmentDisplay(char c) {
            this.aff = c;
            this.setPreferredSize(new Dimension(60, 80));
        }

        public void modifyDisplay(char c) {
            this.aff = c;
            this.repaint();
        }

        public void SwitchSegment(Graphics graphics, char c) {
            switch (c) {
                case 'a': {
                    int[] nArray = new int[]{12, 9, 12};
                    int[] nArray2 = new int[]{36, 39, 36};
                    int[] nArray3 = new int[]{5, 8, 11};
                    graphics.fillPolygon(nArray, nArray3, 3);
                    graphics.fillPolygon(nArray2, nArray3, 3);
                    graphics.fillRect(12, 5, 24, 6);
                    break;
                }
                case 'b': {
                    int[] nArray = new int[]{37, 40, 43};
                    int[] nArray4 = new int[]{12, 9, 12};
                    int[] nArray5 = new int[]{36, 39, 36};
                    graphics.fillPolygon(nArray, nArray4, 3);
                    graphics.fillPolygon(nArray, nArray5, 3);
                    graphics.fillRect(37, 12, 6, 24);
                    break;
                }
                case 'c': {
                    int[] nArray = new int[]{37, 40, 43};
                    int[] nArray6 = new int[]{44, 41, 44};
                    int[] nArray7 = new int[]{68, 71, 68};
                    graphics.fillPolygon(nArray, nArray6, 3);
                    graphics.fillPolygon(nArray, nArray7, 3);
                    graphics.fillRect(37, 44, 6, 24);
                    break;
                }
                case 'd': {
                    int[] nArray = new int[]{12, 9, 12};
                    int[] nArray8 = new int[]{36, 39, 36};
                    int[] nArray9 = new int[]{69, 72, 75};
                    graphics.fillPolygon(nArray, nArray9, 3);
                    graphics.fillPolygon(nArray8, nArray9, 3);
                    graphics.fillRect(12, 69, 24, 6);
                    break;
                }
                case 'e': {
                    int[] nArray = new int[]{5, 8, 11};
                    int[] nArray10 = new int[]{44, 41, 44};
                    int[] nArray11 = new int[]{68, 71, 68};
                    graphics.fillPolygon(nArray, nArray10, 3);
                    graphics.fillPolygon(nArray, nArray11, 3);
                    graphics.fillRect(5, 44, 6, 24);
                    break;
                }
                case 'f': {
                    int[] nArray = new int[]{5, 8, 11};
                    int[] nArray12 = new int[]{12, 9, 12};
                    int[] nArray13 = new int[]{36, 39, 36};
                    graphics.fillPolygon(nArray, nArray12, 3);
                    graphics.fillPolygon(nArray, nArray13, 3);
                    graphics.fillRect(5, 12, 6, 24);
                    break;
                }
                case 'g': {
                    int[] nArray = new int[]{12, 9, 12};
                    int[] nArray14 = new int[]{36, 39, 36};
                    int[] nArray15 = new int[]{37, 40, 43};
                    graphics.fillPolygon(nArray, nArray15, 3);
                    graphics.fillPolygon(nArray14, nArray15, 3);
                    graphics.fillRect(12, 37, 24, 6);
                    break;
                }
                case 'h': {
                    graphics.fillOval(49, 68, 8, 8);
                }
            }
        }

        @Override
        public void paint(Graphics graphics) {
            for (char c = 'a'; c <= 'h'; c = (char)(c + '\u0001')) {
                if ((this.aff & '\u0001') == 1) {
                    graphics.setColor(Color.RED);
                } else {
                    graphics.setColor(Color.LIGHT_GRAY);
                }
                this.SwitchSegment(graphics, c);
                this.aff = (char)(this.aff >>> 1);
            }
        }
    }
}

