/*
 * Decompiled with CFR 0.152.
 */
package rars.tools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.JComponent;
import rars.ProgramStatement;
import rars.riscv.hardware.AccessNotice;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.MemoryAccessNotice;
import rars.riscv.hardware.RegisterFile;
import rars.riscv.instructions.Branch;
import rars.tools.AbstractToolAndApplication;
import rars.tools.BHTSimGUI;
import rars.tools.BHTableModel;

public class BHTSimulator
extends AbstractToolAndApplication
implements ActionListener {
    public static final int BHT_DEFAULT_SIZE = 16;
    public static final int BHT_DEFAULT_HISTORY = 1;
    public static final boolean BHT_DEFAULT_INITVAL = false;
    public static final String BHT_NAME = "BHT Simulator";
    public static final String BHT_VERSION = "Version 1.0 (Ingo Kofler)";
    public static final String BHT_HEADING = "Branch History Table Simulator";
    private BHTSimGUI m_gui;
    private BHTableModel m_bhtModel;
    private int m_pendingBranchInstAddress;
    private boolean m_lastBranchTaken;

    public BHTSimulator() {
        super("BHT Simulator, Version 1.0 (Ingo Kofler)", BHT_HEADING);
    }

    @Override
    protected void addAsObserver() {
        this.addAsObserver(Memory.textBaseAddress, Memory.textLimitAddress);
        this.addAsObserver(RegisterFile.getProgramCounterRegister());
    }

    @Override
    protected JComponent buildMainDisplayArea() {
        this.m_gui = new BHTSimGUI();
        this.m_bhtModel = new BHTableModel(16, 1, false);
        this.m_gui.getTabBHT().setModel(this.m_bhtModel);
        this.m_gui.getCbBHThistory().setSelectedItem(1);
        this.m_gui.getCbBHTentries().setSelectedItem(16);
        this.m_gui.getCbBHTentries().addActionListener(this);
        this.m_gui.getCbBHThistory().addActionListener(this);
        this.m_gui.getCbBHTinitVal().addActionListener(this);
        return this.m_gui;
    }

    @Override
    public String getName() {
        return BHT_NAME;
    }

    @Override
    protected void reset() {
        this.resetSimulator();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_gui.getCbBHTentries() || actionEvent.getSource() == this.m_gui.getCbBHThistory() || actionEvent.getSource() == this.m_gui.getCbBHTinitVal()) {
            this.resetSimulator();
        }
    }

    protected void resetSimulator() {
        this.m_gui.getTfInstruction().setText("");
        this.m_gui.getTfAddress().setText("");
        this.m_gui.getTfIndex().setText("");
        this.m_gui.getTaLog().setText("");
        this.m_bhtModel.initBHT((Integer)this.m_gui.getCbBHTentries().getSelectedItem(), (Integer)this.m_gui.getCbBHThistory().getSelectedItem(), ((String)this.m_gui.getCbBHTinitVal().getSelectedItem()).equals("TAKE"));
        this.m_pendingBranchInstAddress = 0;
        this.m_lastBranchTaken = false;
    }

    protected void handlePreBranchInst(ProgramStatement programStatement) {
        String string = programStatement.getBasicAssemblyStatement();
        int n = programStatement.getAddress();
        int n2 = this.m_bhtModel.getIdxForAddress(n);
        this.m_gui.getTfInstruction().setText(string);
        this.m_gui.getTfAddress().setText("0x" + Integer.toHexString(n));
        this.m_gui.getTfIndex().setText("" + n2);
        this.m_gui.getTabBHT().setSelectionBackground(BHTSimGUI.COLOR_PREPREDICTION);
        this.m_gui.getTabBHT().addRowSelectionInterval(n2, n2);
        this.m_gui.getTaLog().append("instruction " + string + " at address 0x" + Integer.toHexString(n) + ", maps to index " + n2 + "\n");
        this.m_gui.getTaLog().append("branches to address 0x" + BHTSimulator.extractBranchAddress(programStatement) + "\n");
        this.m_gui.getTaLog().append("prediction is: " + (this.m_bhtModel.getPredictionAtIdx(n2) ? "take" : "do not take") + "...\n");
        this.m_gui.getTaLog().setCaretPosition(this.m_gui.getTaLog().getDocument().getLength());
    }

    protected void handleExecBranchInst(int n, boolean bl) {
        int n2 = this.m_bhtModel.getIdxForAddress(n);
        boolean bl2 = this.m_bhtModel.getPredictionAtIdx(n2) == bl;
        this.m_gui.getTabBHT().setSelectionBackground(bl2 ? BHTSimGUI.COLOR_PREDICTION_CORRECT : BHTSimGUI.COLOR_PREDICTION_INCORRECT);
        this.m_gui.getTaLog().append("branch " + (bl ? "taken" : "not taken") + ", prediction was " + (bl2 ? "correct" : "incorrect") + "\n\n");
        this.m_gui.getTaLog().setCaretPosition(this.m_gui.getTaLog().getDocument().getLength());
        this.m_bhtModel.updatePredictionAtIdx(n2, bl);
    }

    protected static int extractBranchAddress(ProgramStatement programStatement) {
        assert (programStatement.getInstruction() instanceof Branch) : "Should only be called on branch instructions";
        int n = programStatement.getOperand(2);
        return programStatement.getAddress() + (n << 1);
    }

    @Override
    protected void processRISCVUpdate(Observable observable, AccessNotice accessNotice) {
        if (!accessNotice.accessIsFromRISCV()) {
            return;
        }
        if (accessNotice.getAccessType() == 0 && accessNotice instanceof MemoryAccessNotice) {
            MemoryAccessNotice memoryAccessNotice = (MemoryAccessNotice)accessNotice;
            try {
                ProgramStatement programStatement = Memory.getInstance().getStatementNoNotify(memoryAccessNotice.getAddress());
                if (programStatement != null) {
                    boolean bl = true;
                    if (this.m_pendingBranchInstAddress != 0) {
                        this.handleExecBranchInst(this.m_pendingBranchInstAddress, this.m_lastBranchTaken);
                        bl = false;
                        this.m_pendingBranchInstAddress = 0;
                    }
                    if (programStatement.getInstruction() instanceof Branch) {
                        this.handlePreBranchInst(programStatement);
                        this.m_lastBranchTaken = ((Branch)programStatement.getInstruction()).willBranch(programStatement);
                        this.m_pendingBranchInstAddress = programStatement.getAddress();
                        bl = false;
                    }
                    if (bl) {
                        this.m_gui.getTfInstruction().setText("");
                        this.m_gui.getTfAddress().setText("");
                        this.m_gui.getTfIndex().setText("");
                        this.m_gui.getTabBHT().clearSelection();
                    }
                } else if (this.m_pendingBranchInstAddress != 0) {
                    this.handleExecBranchInst(this.m_pendingBranchInstAddress, this.m_lastBranchTaken);
                    this.m_pendingBranchInstAddress = 0;
                }
            }
            catch (AddressErrorException addressErrorException) {
                // empty catch block
            }
        }
    }
}

