/*
 * Decompiled with CFR 0.152.
 */
package rars.simulator;

import java.util.ArrayList;
import java.util.StringTokenizer;
import rars.Globals;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.RegisterFile;

public class ProgramArgumentList {
    private ArrayList<String> programArgumentList;

    public ProgramArgumentList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.programArgumentList = new ArrayList(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            this.programArgumentList.add(stringTokenizer.nextToken());
        }
    }

    public ProgramArgumentList(String[] stringArray) {
        this(stringArray, 0);
    }

    public ProgramArgumentList(String[] stringArray, int n) {
        this.programArgumentList = new ArrayList(stringArray.length - n);
        for (int i = n; i < stringArray.length; ++i) {
            this.programArgumentList.add(stringArray[i]);
        }
    }

    public ProgramArgumentList(ArrayList<String> arrayList) {
        this(arrayList, 0);
    }

    public ProgramArgumentList(ArrayList<String> arrayList, int n) {
        if (arrayList == null || arrayList.size() < n) {
            this.programArgumentList = new ArrayList(0);
        } else {
            this.programArgumentList = new ArrayList(arrayList.size() - n);
            for (int i = n; i < arrayList.size(); ++i) {
                this.programArgumentList.add(arrayList.get(i));
            }
        }
    }

    public void storeProgramArguments() {
        if (this.programArgumentList == null || this.programArgumentList.size() == 0) {
            return;
        }
        int n = Memory.stackBaseAddress;
        int[] nArray = new int[this.programArgumentList.size()];
        try {
            int n2;
            int n3;
            for (n3 = 0; n3 < this.programArgumentList.size(); ++n3) {
                String string = this.programArgumentList.get(n3);
                Globals.memory.set(n, 0, 1);
                --n;
                for (n2 = string.length() - 1; n2 >= 0; --n2) {
                    Globals.memory.set(n, string.charAt(n2), 1);
                    --n;
                }
                nArray[n3] = n + 1;
            }
            n3 = Memory.stackPointer;
            if (n < Memory.stackPointer) {
                n3 = n - n % 4 - 4;
            }
            Globals.memory.set(n3, 0, 4);
            n3 -= 4;
            for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                Globals.memory.set(n3, nArray[n2], 4);
                n3 -= 4;
            }
            Globals.memory.set(n3, nArray.length, 4);
            RegisterFile.getRegister("sp").setValue((n3 -= 4) + 4);
            RegisterFile.getRegister("a0").setValue(nArray.length);
            RegisterFile.getRegister("a1").setValue(n3 + 4 + 4);
        }
        catch (AddressErrorException addressErrorException) {
            System.out.println("Internal Error: Memory write error occurred while storing program arguments! " + addressErrorException);
            System.exit(0);
        }
    }
}

