/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.syscalls;

import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.AbstractSyscall;
import rars.riscv.hardware.RegisterFile;
import rars.util.SystemIO;

public class SyscallReadInt
extends AbstractSyscall {
    public SyscallReadInt() {
        super("ReadInt", "Reads an int from input console", "N/A", "a0 = the int");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        try {
            RegisterFile.updateRegister("a0", (long)SystemIO.readInteger(this.getNumber()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new SimulationException(programStatement, "invalid integer input (syscall " + this.getNumber() + ")", 8);
        }
    }
}

