/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.syscalls;

import javax.swing.JOptionPane;
import rars.ExitingException;
import rars.Globals;
import rars.ProgramStatement;
import rars.riscv.AbstractSyscall;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.RegisterFile;

public class SyscallMessageDialogDouble
extends AbstractSyscall {
    public SyscallMessageDialogDouble() {
        super("MessageDialogDouble", "Service to display message followed by a double", "a0 = address of null-terminated string that is the message to user <br> fa0 = the double", "N/A");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws ExitingException {
        String string = new String();
        int n = RegisterFile.getValue("a0");
        char[] cArray = new char[]{' '};
        try {
            cArray[0] = (char)Globals.memory.getByte(n);
            while (cArray[0] != '\u0000') {
                string = string.concat(new String(cArray));
                cArray[0] = (char)Globals.memory.getByte(++n);
            }
        }
        catch (AddressErrorException addressErrorException) {
            throw new ExitingException(programStatement, addressErrorException);
        }
        JOptionPane.showMessageDialog(null, string + Double.longBitsToDouble(FloatingPointRegisterFile.getValueLong(10)), null, 1);
    }
}

