/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import java.math.BigInteger;
import rars.riscv.instructions.Arithmetic;

public class MULHSU
extends Arithmetic {
    public MULHSU() {
        super("mulhsu t1,t2,t3", "Multiplication: set t1 to the upper 32 bits of t2*t3 where t2 is signed and t3 is unsigned", "0000001", "010");
    }

    @Override
    public long compute(long l, long l2) {
        BigInteger bigInteger = BigInteger.valueOf(l2);
        if (l2 < 0L) {
            bigInteger = bigInteger.add(BigInteger.ONE.shiftLeft(64));
        }
        return BigInteger.valueOf(l).multiply(bigInteger).shiftRight(64).longValue();
    }

    @Override
    public int computeW(int n, int n2) {
        long l = (long)n << 32 >> 32;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        return (int)(l * l2 >> 32);
    }
}

