/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import jsoftfloat.Environment;
import jsoftfloat.operations.Arithmetic;
import jsoftfloat.types.Float32;
import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.instructions.Floating;

public class FSQRTS
extends BasicInstruction {
    public FSQRTS() {
        super("fsqrt.s f1, f2, dyn", "Floating SQuare RooT: Assigns f1 to the square root of f2", BasicInstructionFormat.I_FORMAT, "0101100 00000 sssss ttt fffff 1010011");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        Environment environment = new Environment();
        environment.mode = Floating.getRoundingMode(nArray[2], programStatement);
        Float32 float32 = Arithmetic.squareRoot(new Float32(FloatingPointRegisterFile.getValue(nArray[1])), environment);
        Floating.setfflags(environment);
        FloatingPointRegisterFile.updateRegister(nArray[0], float32.bits);
    }
}

