/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import rars.ProgramStatement;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.FloatingPointRegisterFile;

public class FSGNJND
extends BasicInstruction {
    public FSGNJND() {
        super("fsgnjn.d f1, f2, f3", "Floating point sign injection (inverted 64 bit):  replace the sign bit of f2 with the opposite of sign bit of f3 and assign it to f1", BasicInstructionFormat.R_FORMAT, "0010001 ttttt sssss 001 fffff 1010011");
    }

    @Override
    public void simulate(ProgramStatement programStatement) {
        int[] nArray = programStatement.getOperands();
        long l = FloatingPointRegisterFile.getValueLong(nArray[1]) & Long.MAX_VALUE | (FloatingPointRegisterFile.getValueLong(nArray[2]) ^ 0xFFFFFFFFFFFFFFFFL) & Long.MIN_VALUE;
        FloatingPointRegisterFile.updateRegisterLong(nArray[0], l);
    }
}

