/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import rars.Globals;
import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.RegisterFile;

public class FLD
extends BasicInstruction {
    public FLD() {
        super("fld f1, -100(t1)", "Load a double from memory", BasicInstructionFormat.I_FORMAT, "ssssssssssss ttttt 011 fffff 0000111");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        nArray[1] = nArray[1] << 20 >> 20;
        try {
            long l = Globals.memory.getWord(RegisterFile.getValue(nArray[2]) + nArray[1]);
            long l2 = Globals.memory.getWord(RegisterFile.getValue(nArray[2]) + nArray[1] + 4);
            FloatingPointRegisterFile.updateRegisterLong(nArray[0], l2 << 32 | l & 0xFFFFFFFFL);
        }
        catch (AddressErrorException addressErrorException) {
            throw new SimulationException(programStatement, addressErrorException);
        }
    }
}

