/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import java.math.BigInteger;
import jsoftfloat.Environment;
import jsoftfloat.operations.Conversions;
import jsoftfloat.types.Float32;
import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.RegisterFile;
import rars.riscv.instructions.Floating;

public class FCVTSLU
extends BasicInstruction {
    public FCVTSLU() {
        super("fcvt.s.lu f1, t1, dyn", "Convert float from unsigned long: Assigns the value of t1 to f1", BasicInstructionFormat.I_FORMAT, "1101000 00011 sssss ttt fffff 1010011", true);
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        Environment environment = new Environment();
        environment.mode = Floating.getRoundingMode(nArray[2], programStatement);
        Float32 float32 = new Float32(0);
        long l = RegisterFile.getValueLong(nArray[1]);
        BigInteger bigInteger = BigInteger.valueOf(l);
        if (l < 0L) {
            bigInteger = bigInteger.add(BigInteger.ONE.shiftLeft(64));
        }
        Float32 float322 = Conversions.convertFromInt(bigInteger, environment, float32);
        Floating.setfflags(environment);
        FloatingPointRegisterFile.updateRegister(nArray[0], float322.bits);
    }
}

