/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import java.math.BigInteger;
import jsoftfloat.Environment;
import jsoftfloat.operations.Conversions;
import jsoftfloat.types.Float32;
import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.RegisterFile;
import rars.riscv.instructions.Floating;

public class FCVTSL
extends BasicInstruction {
    public FCVTSL() {
        super("fcvt.s.l f1, t1, dyn", "Convert float from long: Assigns the value of t1 to f1", BasicInstructionFormat.I_FORMAT, "1101000 00010 sssss ttt fffff 1010011", true);
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        Environment environment = new Environment();
        environment.mode = Floating.getRoundingMode(nArray[2], programStatement);
        Float32 float32 = new Float32(0);
        Float32 float322 = Conversions.convertFromInt(BigInteger.valueOf(RegisterFile.getValueLong(nArray[1])), environment, float32);
        Floating.setfflags(environment);
        FloatingPointRegisterFile.updateRegister(nArray[0], float322.bits);
    }
}

