/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import jsoftfloat.Environment;
import jsoftfloat.operations.Conversions;
import jsoftfloat.types.Float32;
import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.RegisterFile;
import rars.riscv.instructions.Floating;

public class FCVTLS
extends BasicInstruction {
    public FCVTLS() {
        super("fcvt.l.s t1, f1, dyn", "Convert 64 bit integer from float: Assigns the value of f1 (rounded) to t1", BasicInstructionFormat.I_FORMAT, "1100000 00010 sssss ttt fffff 1010011", true);
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        Environment environment = new Environment();
        environment.mode = Floating.getRoundingMode(nArray[2], programStatement);
        Float32 float32 = new Float32(FloatingPointRegisterFile.getValue(nArray[1]));
        long l = Conversions.convertToLong(float32, environment, false);
        Floating.setfflags(environment);
        RegisterFile.updateRegister(nArray[0], l);
    }
}

