/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.hardware;

import java.util.Observer;
import rars.Globals;
import rars.Settings;
import rars.assembler.SymbolTable;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.Register;
import rars.riscv.hardware.RegisterBlock;

public class RegisterFile {
    public static final int GLOBAL_POINTER_REGISTER = 3;
    public static final int STACK_POINTER_REGISTER = 2;
    private static final RegisterBlock instance = new RegisterBlock('x', new Register[]{new Register("zero", 0, 0L), new Register("ra", 1, 0L), new Register("sp", 2, Memory.stackPointer), new Register("gp", 3, Memory.globalPointer), new Register("tp", 4, 0L), new Register("t0", 5, 0L), new Register("t1", 6, 0L), new Register("t2", 7, 0L), new Register("s0", 8, 0L), new Register("s1", 9, 0L), new Register("a0", 10, 0L), new Register("a1", 11, 0L), new Register("a2", 12, 0L), new Register("a3", 13, 0L), new Register("a4", 14, 0L), new Register("a5", 15, 0L), new Register("a6", 16, 0L), new Register("a7", 17, 0L), new Register("s2", 18, 0L), new Register("s3", 19, 0L), new Register("s4", 20, 0L), new Register("s5", 21, 0L), new Register("s6", 22, 0L), new Register("s7", 23, 0L), new Register("s8", 24, 0L), new Register("s9", 25, 0L), new Register("s10", 26, 0L), new Register("s11", 27, 0L), new Register("t3", 28, 0L), new Register("t4", 29, 0L), new Register("t5", 30, 0L), new Register("t6", 31, 0L)});
    private static Register programCounter = new Register("pc", -1, Memory.textBaseAddress);

    public static void updateRegister(int n, long l) {
        if (n != 0) {
            if (Globals.getSettings().getBackSteppingEnabled()) {
                Globals.program.getBackStepper().addRegisterFileRestore(n, instance.updateRegister(n, l));
            } else {
                instance.updateRegister(n, l);
            }
        }
    }

    public static void updateRegister(String string, long l) {
        RegisterFile.updateRegister(instance.getRegister(string).getNumber(), l);
    }

    public static int getValue(int n) {
        return (int)instance.getValue(n);
    }

    public static long getValueLong(int n) {
        return instance.getValue(n);
    }

    public static int getValue(String string) {
        return (int)instance.getValue(string);
    }

    public static Register[] getRegisters() {
        return instance.getRegisters();
    }

    public static Register getRegister(String string) {
        if (string.equals("fp")) {
            return instance.getRegister("s0");
        }
        return instance.getRegister(string);
    }

    public static void initializeProgramCounter(int n) {
        programCounter.setValue(n);
    }

    public static void initializeProgramCounter(boolean bl) {
        int n = Globals.symbolTable.getAddress(SymbolTable.getStartLabel());
        if (bl && n != -1 && Memory.inTextSegment(n)) {
            RegisterFile.initializeProgramCounter(n);
        } else {
            RegisterFile.initializeProgramCounter((int)programCounter.getResetValue());
        }
    }

    public static int setProgramCounter(int n) {
        int n2 = (int)programCounter.getValue();
        programCounter.setValue(n);
        if (Globals.getSettings().getBackSteppingEnabled()) {
            Globals.program.getBackStepper().addPCRestore(n2);
        }
        return n2;
    }

    public static int getProgramCounter() {
        return (int)programCounter.getValue();
    }

    public static Register getProgramCounterRegister() {
        return programCounter;
    }

    public static int getInitialProgramCounter() {
        return (int)programCounter.getResetValue();
    }

    public static void resetRegisters() {
        instance.resetRegisters();
        RegisterFile.initializeProgramCounter(Globals.getSettings().getBooleanSetting(Settings.Bool.START_AT_MAIN));
    }

    public static void incrementPC() {
        programCounter.setValue(programCounter.getValue() + 4L);
    }

    public static void addRegistersObserver(Observer observer) {
        instance.addRegistersObserver(observer);
    }

    public static void deleteRegistersObserver(Observer observer) {
        instance.deleteRegistersObserver(observer);
    }
}

