/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.hardware;

import java.util.ArrayList;
import java.util.Iterator;
import rars.Globals;
import rars.riscv.hardware.MemoryConfiguration;
import rars.riscv.hardware.RegisterFile;

public class MemoryConfigurations {
    private static ArrayList<MemoryConfiguration> configurations = null;
    private static MemoryConfiguration defaultConfiguration;
    private static MemoryConfiguration currentConfiguration;
    private static final String[] configurationItemNames;
    private static int[] defaultConfigurationItemValues;
    private static int[] dataBasedCompactConfigurationItemValues;
    private static int[] textBasedCompactConfigurationItemValues;

    public static void buildConfigurationCollection() {
        if (configurations == null) {
            configurations = new ArrayList();
            configurations.add(new MemoryConfiguration("Default", "Default", configurationItemNames, defaultConfigurationItemValues));
            configurations.add(new MemoryConfiguration("CompactDataAtZero", "Compact, Data at Address 0", configurationItemNames, dataBasedCompactConfigurationItemValues));
            configurations.add(new MemoryConfiguration("CompactTextAtZero", "Compact, Text at Address 0", configurationItemNames, textBasedCompactConfigurationItemValues));
            currentConfiguration = defaultConfiguration = configurations.get(0);
            MemoryConfigurations.setCurrentConfiguration(MemoryConfigurations.getConfigurationByName(Globals.getSettings().getMemoryConfiguration()));
        }
    }

    public static Iterator<MemoryConfiguration> getConfigurationsIterator() {
        if (configurations == null) {
            MemoryConfigurations.buildConfigurationCollection();
        }
        return configurations.iterator();
    }

    public static MemoryConfiguration getConfigurationByName(String string) {
        Iterator<MemoryConfiguration> iterator = MemoryConfigurations.getConfigurationsIterator();
        while (iterator.hasNext()) {
            MemoryConfiguration memoryConfiguration = iterator.next();
            if (!string.equals(memoryConfiguration.getConfigurationIdentifier())) continue;
            return memoryConfiguration;
        }
        return null;
    }

    public static MemoryConfiguration getDefaultConfiguration() {
        if (defaultConfiguration == null) {
            MemoryConfigurations.buildConfigurationCollection();
        }
        return defaultConfiguration;
    }

    public static MemoryConfiguration getCurrentConfiguration() {
        if (currentConfiguration == null) {
            MemoryConfigurations.buildConfigurationCollection();
        }
        return currentConfiguration;
    }

    public static boolean setCurrentConfiguration(MemoryConfiguration memoryConfiguration) {
        if (memoryConfiguration == null) {
            return false;
        }
        if (memoryConfiguration != currentConfiguration) {
            currentConfiguration = memoryConfiguration;
            Globals.memory.clear();
            RegisterFile.getRegister("gp").changeResetValue(memoryConfiguration.getGlobalPointer());
            RegisterFile.getRegister("sp").changeResetValue(memoryConfiguration.getStackPointer());
            RegisterFile.getProgramCounterRegister().changeResetValue(memoryConfiguration.getTextBaseAddress());
            RegisterFile.initializeProgramCounter(memoryConfiguration.getTextBaseAddress());
            RegisterFile.resetRegisters();
            return true;
        }
        return false;
    }

    public static int getDefaultTextBaseAddress() {
        return defaultConfigurationItemValues[0];
    }

    public static int getDefaultDataSegmentBaseAddress() {
        return defaultConfigurationItemValues[1];
    }

    public static int getDefaultExternBaseAddress() {
        return defaultConfigurationItemValues[2];
    }

    public static int getDefaultGlobalPointer() {
        return defaultConfigurationItemValues[3];
    }

    public static int getDefaultDataBaseAddress() {
        return defaultConfigurationItemValues[4];
    }

    public static int getDefaultHeapBaseAddress() {
        return defaultConfigurationItemValues[5];
    }

    public static int getDefaultStackPointer() {
        return defaultConfigurationItemValues[6];
    }

    public static int getDefaultStackBaseAddress() {
        return defaultConfigurationItemValues[7];
    }

    public static int getDefaultUserHighAddress() {
        return defaultConfigurationItemValues[8];
    }

    public static int getDefaultKernelBaseAddress() {
        return defaultConfigurationItemValues[9];
    }

    public static int getDefaultMemoryMapBaseAddress() {
        return defaultConfigurationItemValues[10];
    }

    public static int getDefaultKernelHighAddress() {
        return defaultConfigurationItemValues[11];
    }

    public int getDefaultDataSegmentLimitAddress() {
        return defaultConfigurationItemValues[12];
    }

    public int getDefaultTextLimitAddress() {
        return defaultConfigurationItemValues[13];
    }

    public int getDefaultStackLimitAddress() {
        return defaultConfigurationItemValues[14];
    }

    public int getMemoryMapLimitAddress() {
        return defaultConfigurationItemValues[15];
    }

    static {
        configurationItemNames = new String[]{".text base address", "data segment base address", ".extern base address", "global pointer (gp)", ".data base address", "heap base address", "stack pointer (sp)", "stack base address", "user space high address", "kernel space base address", "MMIO base address", "kernel space high address", "data segment limit address", "text limit address", "stack limit address", "memory map limit address"};
        defaultConfigurationItemValues = new int[]{0x400000, 0x10000000, 0x10000000, 0x10008000, 0x10010000, 0x10040000, 2147479548, 0x7FFFFFFC, Integer.MAX_VALUE, Integer.MIN_VALUE, -65536, -1, Integer.MAX_VALUE, 0xFFFFFFC, 0x10040000, -1};
        dataBasedCompactConfigurationItemValues = new int[]{12288, 0, 4096, 6144, 0, 8192, 12284, 12284, 16383, 16384, 32512, Short.MAX_VALUE, 12287, 16380, 8192, Short.MAX_VALUE};
        textBasedCompactConfigurationItemValues = new int[]{0, 4096, 4096, 6144, 8192, 12288, 16380, 16380, 16383, 16384, 32512, Short.MAX_VALUE, 16383, 4092, 12288, Short.MAX_VALUE};
    }
}

