/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv;

import java.util.StringTokenizer;
import rars.AssemblyException;
import rars.assembler.TokenList;
import rars.assembler.Tokenizer;

public abstract class Instruction {
    public static final int INSTRUCTION_LENGTH = 4;
    public static final int INSTRUCTION_LENGTH_BITS = 32;
    public static char[] operandMask = new char[]{'f', 's', 't', 'q', 'p'};
    protected String mnemonic;
    protected String exampleFormat;
    protected String description;
    protected TokenList tokenList;

    public String getName() {
        return this.mnemonic;
    }

    public String getExampleFormat() {
        return this.exampleFormat;
    }

    public String getDescription() {
        return this.description;
    }

    public TokenList getTokenList() {
        return this.tokenList;
    }

    public int getInstructionLength() {
        return 4;
    }

    protected String extractOperator(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,\t");
        return stringTokenizer.nextToken();
    }

    protected void createExampleTokenList() {
        try {
            this.tokenList = new Tokenizer().tokenizeExampleInstruction(this.exampleFormat);
        }
        catch (AssemblyException assemblyException) {
            System.out.println("CONFIGURATION ERROR: Instruction example \"" + this.exampleFormat + "\" contains invalid token(s).");
        }
    }
}

