/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv;

import java.util.ArrayList;
import java.util.StringTokenizer;
import rars.RISCVprogram;
import rars.assembler.Symbol;
import rars.assembler.TokenList;
import rars.riscv.Instruction;
import rars.util.Binary;

public class ExtendedInstruction
extends Instruction {
    private ArrayList<String> translationStrings;

    public ExtendedInstruction(String string, String string2, String string3) {
        this.exampleFormat = string;
        this.description = string3;
        this.mnemonic = this.extractOperator(string);
        this.createExampleTokenList();
        this.translationStrings = this.buildTranslationList(string2);
    }

    public ExtendedInstruction(String string, String string2) {
        this(string, string2, "");
    }

    @Override
    public int getInstructionLength() {
        return this.getInstructionLength(this.translationStrings);
    }

    public ArrayList<String> getBasicIntructionTemplateList() {
        return this.translationStrings;
    }

    public static String makeTemplateSubstitutions(RISCVprogram rISCVprogram, String string, TokenList tokenList, int n) {
        Object object;
        String string2 = string;
        for (int i = 1; i < tokenList.size(); ++i) {
            int n2;
            string2 = ExtendedInstruction.substitute(string2, "RG" + i, tokenList.get(i).getValue());
            object = tokenList.get(i).getValue();
            try {
                n2 = Binary.stringToInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                long l;
                try {
                    l = Binary.stringToLong((String)object);
                }
                catch (NumberFormatException numberFormatException2) {
                    continue;
                }
                n2 = (int)(l >> 32);
                int n3 = (int)l;
                if (string2.contains("LIA" + i)) {
                    int n4 = Binary.bitValue(n2, 11);
                    string2 = ExtendedInstruction.substitute(string2, "LIA" + i, String.valueOf((n2 >> 12) + n4));
                    continue;
                }
                if (string2.contains("LIB" + i)) {
                    string2 = ExtendedInstruction.substitute(string2, "LIB" + i, String.valueOf(n2 << 20 >> 20));
                    continue;
                }
                if (string2.contains("LIC" + i)) {
                    string2 = ExtendedInstruction.substitute(string2, "LIC" + i, String.valueOf(n3 >> 21 & 0x7FF));
                    continue;
                }
                if (string2.contains("LID" + i)) {
                    string2 = ExtendedInstruction.substitute(string2, "LID" + i, String.valueOf(n3 >> 10 & 0x7FF));
                    continue;
                }
                if (!string2.contains("LIE" + i)) continue;
                string2 = ExtendedInstruction.substitute(string2, "LIE" + i, String.valueOf(n3 & 0x3FF));
                continue;
            }
            int n5 = n2 - n;
            if (string2.contains("PCH" + i)) {
                int n6 = Binary.bitValue(n5, 11);
                string2 = ExtendedInstruction.substitute(string2, "PCH" + i, String.valueOf((n5 >> 12) + n6));
            }
            if (string2.contains("PCL" + i)) {
                string2 = ExtendedInstruction.substitute(string2, "PCL" + i, String.valueOf(n5 << 20 >> 20));
            }
            if (string2.contains("LH" + i)) {
                int n7 = Binary.bitValue(n2, 11);
                string2 = ExtendedInstruction.substitute(string2, "LH" + i, String.valueOf((n2 >> 12) + n7));
            }
            if (string2.contains("LL" + i)) {
                string2 = ExtendedInstruction.substitute(string2, "LL" + i, String.valueOf(n2 << 20 >> 20));
            }
            if (string2.contains("VH" + i)) {
                int n8 = Binary.bitValue(n2, 11);
                string2 = ExtendedInstruction.substitute(string2, "VH" + i, String.valueOf((n2 >> 12) + n8));
            }
            if (!string2.contains("VL" + i)) continue;
            string2 = ExtendedInstruction.substitute(string2, "VL" + i, String.valueOf(n2 << 20 >> 20));
        }
        if (string2.contains("LAB")) {
            String string3 = tokenList.get(tokenList.size() - 1).getValue();
            object = rISCVprogram.getLocalSymbolTable().getSymbolGivenAddressLocalOrGlobal(string3);
            if (object != null) {
                string2 = ExtendedInstruction.substituteFirst(string2, "LAB", ((Symbol)object).getName());
            }
        }
        return string2;
    }

    private static String substitute(String string, String string2, String string3) {
        int n;
        if (!string.contains(string2) || string2.equals(string3)) {
            return string;
        }
        Object object = string;
        while ((n = ((String)object).indexOf(string2)) >= 0) {
            object = ((String)object).substring(0, n) + string3 + ((String)object).substring(n + string2.length());
        }
        return object;
    }

    private static String substituteFirst(String string, String string2, String string3) {
        if (!string.contains(string2) || string2.equals(string3)) {
            return string;
        }
        Object object = string;
        int n = ((String)object).indexOf(string2);
        if (n >= 0) {
            object = ((String)object).substring(0, n) + string3 + ((String)object).substring(n + string2.length());
        }
        return object;
    }

    private ArrayList<String> buildTranslationList(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    private int getInstructionLength(ArrayList<String> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return 0;
        }
        return 4 * arrayList.size();
    }
}

