/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv;

import rars.ProgramStatement;
import rars.SimulationException;

public abstract class AbstractSyscall
implements Comparable<AbstractSyscall> {
    private int serviceNumber = -1;
    private String serviceName;
    private String description;
    private String inputs;
    private String outputs;

    protected AbstractSyscall(String string) {
        this(string, "N/A");
    }

    protected AbstractSyscall(String string, String string2) {
        this(string, string2, "N/A", "N/A");
    }

    protected AbstractSyscall(String string, String string2, String string3, String string4) {
        this.serviceName = string;
        this.description = string2;
        this.inputs = string3;
        this.outputs = string4;
    }

    public String getName() {
        return this.serviceName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInputs() {
        return this.inputs;
    }

    public String getOutputs() {
        return this.outputs;
    }

    public void setNumber(int n) {
        this.serviceNumber = n;
    }

    public int getNumber() {
        return this.serviceNumber;
    }

    public abstract void simulate(ProgramStatement var1) throws SimulationException;

    @Override
    public int compareTo(AbstractSyscall abstractSyscall) {
        if (this == abstractSyscall) {
            return 0;
        }
        assert (this.getNumber() != abstractSyscall.getNumber()) : "Different syscalls have to have different numbers";
        return this.getNumber() > abstractSyscall.getNumber() ? 1 : -1;
    }
}

