/*
 * Decompiled with CFR 0.152.
 */
package rars.assembler;

import java.util.ArrayList;
import rars.RISCVprogram;
import rars.assembler.Macro;
import rars.assembler.Token;
import rars.assembler.TokenList;

public class MacroPool {
    private RISCVprogram program;
    private ArrayList<Macro> macroList;
    private Macro current;
    private ArrayList<Integer> callStack;
    private ArrayList<Integer> callStackOrigLines;
    private int counter;

    public MacroPool(RISCVprogram rISCVprogram) {
        this.program = rISCVprogram;
        this.macroList = new ArrayList();
        this.callStack = new ArrayList();
        this.callStackOrigLines = new ArrayList();
        this.current = null;
        this.counter = 0;
    }

    public void beginMacro(Token token) {
        this.current = new Macro();
        this.current.setName(token.getValue());
        this.current.setFromLine(token.getSourceLine());
        this.current.setOriginalFromLine(token.getOriginalSourceLine());
        this.current.setProgram(this.program);
    }

    public void commitMacro(Token token) {
        this.current.setToLine(token.getSourceLine());
        this.current.setOriginalToLine(token.getOriginalSourceLine());
        this.current.readyForCommit();
        this.macroList.add(this.current);
        this.current = null;
    }

    public Macro getMatchingMacro(TokenList tokenList, int n) {
        if (tokenList.size() < 1) {
            return null;
        }
        Macro macro = null;
        Token token = tokenList.get(0);
        for (Macro macro2 : this.macroList) {
            if (!macro2.getName().equals(token.getValue()) || macro2.getArgs().size() + 1 != tokenList.size() || macro != null && macro.getFromLine() >= macro2.getFromLine()) continue;
            macro = macro2;
        }
        return macro;
    }

    public boolean matchesAnyMacroName(String string) {
        for (Macro macro : this.macroList) {
            if (!macro.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Macro getCurrent() {
        return this.current;
    }

    public void setCurrent(Macro macro) {
        this.current = macro;
    }

    public int getNextCounter() {
        return this.counter++;
    }

    public ArrayList<Integer> getCallStack() {
        return this.callStack;
    }

    public boolean pushOnCallStack(Token token) {
        int n = token.getSourceLine();
        int n2 = token.getOriginalSourceLine();
        if (this.callStack.contains(n)) {
            return true;
        }
        this.callStack.add(n);
        this.callStackOrigLines.add(n2);
        return false;
    }

    public void popFromCallStack() {
        this.callStack.remove(this.callStack.size() - 1);
        this.callStackOrigLines.remove(this.callStackOrigLines.size() - 1);
    }

    public String getExpansionHistory() {
        Object object = "";
        for (int i = 0; i < this.callStackOrigLines.size(); ++i) {
            if (i > 0) {
                object = (String)object + "->";
            }
            object = (String)object + this.callStackOrigLines.get(i).toString();
        }
        return object;
    }
}

