/*
 * Decompiled with CFR 0.152.
 */
package rars.assembler;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import rars.AssemblyException;
import rars.ErrorList;
import rars.ErrorMessage;
import rars.Globals;
import rars.ProgramStatement;
import rars.RISCVprogram;
import rars.Settings;
import rars.assembler.DataTypes;
import rars.assembler.Directives;
import rars.assembler.Macro;
import rars.assembler.MacroPool;
import rars.assembler.OperandFormat;
import rars.assembler.SourceLine;
import rars.assembler.Symbol;
import rars.assembler.SymbolTable;
import rars.assembler.Token;
import rars.assembler.TokenList;
import rars.assembler.TokenTypes;
import rars.assembler.Tokenizer;
import rars.riscv.BasicInstruction;
import rars.riscv.ExtendedInstruction;
import rars.riscv.Instruction;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.Memory;
import rars.util.Binary;
import rars.util.SystemIO;
import rars.venus.NumberDisplayBaseChooser;

public class Assembler {
    private ErrorList errors;
    private boolean inDataSegment;
    private boolean inMacroSegment;
    private int externAddress;
    private boolean autoAlign;
    private Directives dataDirective;
    private RISCVprogram fileCurrentlyBeingAssembled;
    private TokenList globalDeclarationList;
    private AddressSpace textAddress;
    private AddressSpace dataAddress;
    private DataSegmentForwardReferences currentFileDataSegmentForwardReferences;
    private DataSegmentForwardReferences accumulatedDataSegmentForwardReferences;

    public ErrorList getErrorList() {
        return this.errors;
    }

    public ArrayList<ProgramStatement> assemble(ArrayList<RISCVprogram> arrayList, boolean bl, boolean bl2) throws AssemblyException {
        ArrayList<ProgramStatement> arrayList2;
        int n;
        Object object;
        Object object2;
        ArrayList<Object> arrayList3;
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        this.textAddress = new AddressSpace(Memory.textBaseAddress);
        this.dataAddress = new AddressSpace(Memory.dataBaseAddress);
        this.externAddress = Memory.externBaseAddress;
        this.currentFileDataSegmentForwardReferences = new DataSegmentForwardReferences();
        this.accumulatedDataSegmentForwardReferences = new DataSegmentForwardReferences();
        Globals.symbolTable.clear();
        Globals.memory.clear();
        ArrayList<ProgramStatement> arrayList4 = new ArrayList<ProgramStatement>();
        this.errors = new ErrorList();
        if (Globals.debug) {
            System.out.println("Assembler first pass begins:");
        }
        for (RISCVprogram object3 : arrayList) {
            if (this.errors.errorLimitExceeded()) break;
            this.fileCurrentlyBeingAssembled = object3;
            this.globalDeclarationList = new TokenList();
            this.inDataSegment = false;
            this.inMacroSegment = false;
            this.autoAlign = true;
            this.dataDirective = Directives.WORD;
            this.fileCurrentlyBeingAssembled.getLocalSymbolTable().clear();
            this.currentFileDataSegmentForwardReferences.clear();
            arrayList3 = this.fileCurrentlyBeingAssembled.getSourceLineList();
            object2 = this.fileCurrentlyBeingAssembled.getTokenList();
            Object object4 = this.fileCurrentlyBeingAssembled.createParsedList();
            object = this.fileCurrentlyBeingAssembled.createMacroPool();
            for (n = 0; n < ((ArrayList)object2).size() && !this.errors.errorLimitExceeded(); ++n) {
                for (Object object5 : (TokenList)((ArrayList)object2).get(n)) {
                    ((Token)object5).setOriginal(((SourceLine)arrayList3.get(n)).getRISCVprogram(), ((SourceLine)arrayList3.get(n)).getLineNumber());
                }
                arrayList2 = this.parseLine((TokenList)((ArrayList)object2).get(n), ((SourceLine)arrayList3.get(n)).getSource(), ((SourceLine)arrayList3.get(n)).getLineNumber(), bl);
                if (arrayList2 == null) continue;
                ((ArrayList)object4).addAll(arrayList2);
            }
            if (this.inMacroSegment) {
                this.errors.add(new ErrorMessage(this.fileCurrentlyBeingAssembled, this.fileCurrentlyBeingAssembled.getLocalMacroPool().getCurrent().getFromLine(), 0, "Macro started but not ended (no .end_macro directive)"));
            }
            this.transferGlobals();
            this.currentFileDataSegmentForwardReferences.resolve(this.fileCurrentlyBeingAssembled.getLocalSymbolTable());
            this.accumulatedDataSegmentForwardReferences.add(this.currentFileDataSegmentForwardReferences);
            this.currentFileDataSegmentForwardReferences.clear();
        }
        this.accumulatedDataSegmentForwardReferences.resolve(Globals.symbolTable);
        this.accumulatedDataSegmentForwardReferences.generateErrorMessages(this.errors);
        if (this.errors.errorsOccurred()) {
            throw new AssemblyException(this.errors);
        }
        if (Globals.debug) {
            System.out.println("Assembler second pass begins");
        }
        for (RISCVprogram rISCVprogram : arrayList) {
            if (this.errors.errorLimitExceeded()) break;
            this.fileCurrentlyBeingAssembled = rISCVprogram;
            arrayList3 = this.fileCurrentlyBeingAssembled.getParsedList();
            for (Object object4 : arrayList3) {
                Object object5;
                ((ProgramStatement)object4).buildBasicStatementFromBasicInstruction(this.errors);
                if (this.errors.errorsOccurred()) {
                    throw new AssemblyException(this.errors);
                }
                if (((ProgramStatement)object4).getInstruction() instanceof BasicInstruction) {
                    arrayList4.add((ProgramStatement)object4);
                    continue;
                }
                object = (ExtendedInstruction)((ProgramStatement)object4).getInstruction();
                arrayList2 = ((ProgramStatement)object4).getBasicAssemblyStatement();
                n = ((ProgramStatement)object4).getSourceLine();
                TokenList tokenList = new Tokenizer().tokenizeLine(n, (String)((Object)arrayList2), this.errors, false);
                object5 = ((ExtendedInstruction)object).getBasicIntructionTemplateList();
                this.textAddress.set(((ProgramStatement)object4).getAddress());
                int n2 = this.textAddress.get();
                for (int i = 0; i < ((ArrayList)object5).size(); ++i) {
                    String string = ExtendedInstruction.makeTemplateSubstitutions(this.fileCurrentlyBeingAssembled, (String)((ArrayList)object5).get(i), tokenList, n2);
                    if (Globals.debug) {
                        System.out.println("PSEUDO generated: " + string);
                    }
                    TokenList tokenList2 = new Tokenizer().tokenizeLine(n, string, this.errors, false);
                    ArrayList<Instruction> arrayList5 = this.matchInstruction(tokenList2.get(0));
                    Instruction instruction = OperandFormat.bestOperandMatch(tokenList2, arrayList5);
                    ProgramStatement programStatement = new ProgramStatement(this.fileCurrentlyBeingAssembled, i == 0 ? ((ProgramStatement)object4).getSource() : "", tokenList2, tokenList2, instruction, this.textAddress.get(), ((ProgramStatement)object4).getSourceLine());
                    this.textAddress.increment(4);
                    programStatement.buildBasicStatementFromBasicInstruction(this.errors);
                    arrayList4.add(programStatement);
                }
            }
        }
        if (Globals.debug) {
            System.out.println("Code generation begins");
        }
        for (ProgramStatement programStatement : arrayList4) {
            if (this.errors.errorLimitExceeded()) break;
            programStatement.buildMachineStatementFromBasicStatement(this.errors);
            if (Globals.debug) {
                System.out.println(programStatement);
            }
            try {
                Globals.memory.setStatement(programStatement.getAddress(), programStatement);
            }
            catch (AddressErrorException addressErrorException) {
                object2 = programStatement.getOriginalTokenList().get(0);
                this.errors.add(new ErrorMessage(((Token)object2).getSourceProgram(), ((Token)object2).getSourceLine(), ((Token)object2).getStartPos(), "Invalid address for text segment: " + addressErrorException.getAddress()));
            }
        }
        SystemIO.resetFiles();
        Collections.sort(arrayList4);
        this.catchDuplicateAddresses(arrayList4, this.errors);
        if (this.errors.errorsOccurred() || this.errors.warningsOccurred() && bl2) {
            throw new AssemblyException(this.errors);
        }
        return arrayList4;
    }

    private void catchDuplicateAddresses(ArrayList<ProgramStatement> arrayList, ErrorList errorList) {
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            ProgramStatement programStatement = arrayList.get(i);
            ProgramStatement programStatement2 = arrayList.get(i + 1);
            if (programStatement.getAddress() != programStatement2.getAddress()) continue;
            errorList.add(new ErrorMessage(programStatement2.getSourceProgram(), programStatement2.getSourceLine(), 0, "Duplicate text segment address: " + NumberDisplayBaseChooser.formatUnsignedInteger(programStatement2.getAddress(), Globals.getSettings().getBooleanSetting(Settings.Bool.DISPLAY_ADDRESSES_IN_HEX) ? 16 : 10) + " already occupied by " + programStatement.getSourceFile() + " line " + programStatement.getSourceLine() + " (caused by use of " + (Memory.inTextSegment(programStatement2.getAddress()) ? ".text" : ".ktext") + " operand)"));
        }
    }

    private ArrayList<ProgramStatement> parseLine(TokenList tokenList, String string, int n, boolean bl) {
        Macro macro;
        ArrayList<ProgramStatement> arrayList = new ArrayList<ProgramStatement>();
        TokenList tokenList2 = this.stripComment(tokenList);
        MacroPool macroPool = this.fileCurrentlyBeingAssembled.getLocalMacroPool();
        if (this.inMacroSegment) {
            this.detectLabels(tokenList2, macroPool.getCurrent());
        } else {
            this.stripLabels(tokenList2);
        }
        if (tokenList2.isEmpty()) {
            return null;
        }
        Token token = tokenList2.get(0);
        TokenTypes tokenTypes = token.getType();
        if (tokenTypes == TokenTypes.DIRECTIVE) {
            this.executeDirective(tokenList2);
            return null;
        }
        if (this.inMacroSegment) {
            return null;
        }
        TokenList tokenList3 = tokenList2;
        if (tokenList2.size() > 2 && tokenList2.get(1).getType() == TokenTypes.LEFT_PAREN && tokenList2.get(tokenList2.size() - 1).getType() == TokenTypes.RIGHT_PAREN) {
            tokenList3 = (TokenList)tokenList2.clone();
            tokenList3.remove(tokenList2.size() - 1);
            tokenList3.remove(1);
        }
        if ((macro = macroPool.getMatchingMacro(tokenList3, n)) != null) {
            tokenList2 = tokenList3;
            int n2 = macroPool.getNextCounter();
            if (macroPool.pushOnCallStack(token)) {
                this.errors.add(new ErrorMessage(this.fileCurrentlyBeingAssembled, tokenList2.get(0).getSourceLine(), 0, "Detected a macro expansion loop (recursive reference). "));
            } else {
                for (int i = macro.getFromLine() + 1; i < macro.getToLine(); ++i) {
                    ArrayList<ProgramStatement> arrayList2;
                    String string2 = macro.getSubstitutedLine(i, tokenList2, n2, this.errors);
                    TokenList tokenList4 = this.fileCurrentlyBeingAssembled.getTokenizer().tokenizeLine(i, string2, this.errors);
                    if (tokenList4.getProcessedLine().length() > 0) {
                        string2 = tokenList4.getProcessedLine();
                    }
                    if ((arrayList2 = this.parseLine(tokenList4, "<" + (i - macro.getFromLine() + macro.getOriginalFromLine()) + "> " + string2.trim(), n, bl)) == null) continue;
                    arrayList.addAll(arrayList2);
                }
                macroPool.popFromCallStack();
            }
            return arrayList;
        }
        if (tokenTypes == TokenTypes.IDENTIFIER && token.getValue().charAt(0) == '.') {
            this.errors.add(new ErrorMessage(true, token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "RARS does not recognize the " + token.getValue() + " directive.  Ignored."));
            return null;
        }
        if (this.inDataSegment && (tokenTypes == TokenTypes.PLUS || tokenTypes == TokenTypes.MINUS || tokenTypes == TokenTypes.QUOTED_STRING || tokenTypes == TokenTypes.IDENTIFIER || TokenTypes.isIntegerTokenType(tokenTypes) || TokenTypes.isFloatingTokenType(tokenTypes))) {
            this.executeDirectiveContinuation(tokenList2);
            return null;
        }
        if (!this.inDataSegment) {
            ArrayList<Instruction> arrayList3 = this.matchInstruction(token);
            if (arrayList3 == null) {
                return arrayList;
            }
            Instruction instruction = OperandFormat.bestOperandMatch(tokenList2, arrayList3);
            if (instruction instanceof ExtendedInstruction && !bl) {
                this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "Extended (pseudo) instruction or format not permitted.  See Settings."));
            }
            if (OperandFormat.tokenOperandMatch(tokenList2, instruction, this.errors)) {
                ProgramStatement programStatement = new ProgramStatement(this.fileCurrentlyBeingAssembled, string, tokenList, tokenList2, instruction, this.textAddress.get(), n);
                int n3 = instruction.getInstructionLength();
                this.textAddress.increment(n3);
                arrayList.add(programStatement);
                return arrayList;
            }
        }
        return null;
    }

    private void detectLabels(TokenList tokenList, Macro macro) {
        if (this.tokenListBeginsWithLabel(tokenList)) {
            macro.addLabel(tokenList.get(0).getValue());
        }
    }

    private TokenList stripComment(TokenList tokenList) {
        int n;
        if (tokenList.isEmpty()) {
            return tokenList;
        }
        TokenList tokenList2 = (TokenList)tokenList.clone();
        if (tokenList2.get(n = tokenList2.size() - 1).getType() == TokenTypes.COMMENT) {
            tokenList2.remove(n);
        }
        return tokenList2;
    }

    private void stripLabels(TokenList tokenList) {
        boolean bl = this.parseAndRecordLabel(tokenList);
        if (bl) {
            tokenList.remove(0);
            tokenList.remove(0);
        }
    }

    private boolean parseAndRecordLabel(TokenList tokenList) {
        if (tokenList.size() < 2) {
            return false;
        }
        Token token = tokenList.get(0);
        if (this.tokenListBeginsWithLabel(tokenList)) {
            if (token.getType() == TokenTypes.OPERATOR) {
                token.setType(TokenTypes.IDENTIFIER);
            }
            this.fileCurrentlyBeingAssembled.getLocalSymbolTable().addSymbol(token, this.inDataSegment ? this.dataAddress.get() : this.textAddress.get(), this.inDataSegment, this.errors);
            return true;
        }
        return false;
    }

    private boolean tokenListBeginsWithLabel(TokenList tokenList) {
        if (tokenList.size() < 2) {
            return false;
        }
        return (tokenList.get(0).getType() == TokenTypes.IDENTIFIER || tokenList.get(0).getType() == TokenTypes.OPERATOR) && tokenList.get(1).getType() == TokenTypes.COLON;
    }

    private void executeDirective(TokenList tokenList) {
        Token token = tokenList.get(0);
        Directives directives = Directives.matchDirective(token.getValue());
        if (Globals.debug) {
            System.out.println("line " + token.getSourceLine() + " is directive " + directives);
        }
        if (directives == null) {
            this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" directive is invalid or not implemented in RARS"));
            return;
        }
        if (directives != Directives.EQV) {
            if (directives == Directives.MACRO) {
                if (tokenList.size() < 2) {
                    this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" directive requires at least one argument."));
                    return;
                }
                if (tokenList.get(1).getType() != TokenTypes.IDENTIFIER) {
                    this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), tokenList.get(1).getStartPos(), "Invalid Macro name \"" + tokenList.get(1).getValue() + "\""));
                    return;
                }
                if (this.inMacroSegment) {
                    this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "Nested macros are not allowed"));
                    return;
                }
                this.inMacroSegment = true;
                MacroPool macroPool = this.fileCurrentlyBeingAssembled.getLocalMacroPool();
                macroPool.beginMacro(tokenList.get(1));
                for (int i = 2; i < tokenList.size(); ++i) {
                    Token token2 = tokenList.get(i);
                    if (token2.getType() == TokenTypes.RIGHT_PAREN || token2.getType() == TokenTypes.LEFT_PAREN) continue;
                    if (!Macro.tokenIsMacroParameter(token2.getValue(), true)) {
                        this.errors.add(new ErrorMessage(token2.getSourceProgram(), token2.getSourceLine(), token2.getStartPos(), "Invalid macro argument '" + token2.getValue() + "'"));
                        return;
                    }
                    macroPool.getCurrent().addArg(token2.getValue());
                }
            } else if (directives == Directives.END_MACRO) {
                if (tokenList.size() > 1) {
                    this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "invalid text after .END_MACRO"));
                    return;
                }
                if (!this.inMacroSegment) {
                    this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), ".END_MACRO without .MACRO"));
                    return;
                }
                this.inMacroSegment = false;
                this.fileCurrentlyBeingAssembled.getLocalMacroPool().commitMacro(token);
            } else {
                if (this.inMacroSegment) {
                    return;
                }
                if (directives == Directives.DATA) {
                    this.inDataSegment = true;
                    this.autoAlign = true;
                    if (tokenList.size() > 1 && TokenTypes.isIntegerTokenType(tokenList.get(1).getType())) {
                        this.dataAddress.set(Binary.stringToInt(tokenList.get(1).getValue()));
                    }
                } else if (directives == Directives.TEXT) {
                    this.inDataSegment = false;
                    if (tokenList.size() > 1 && TokenTypes.isIntegerTokenType(tokenList.get(1).getType())) {
                        this.textAddress.set(Binary.stringToInt(tokenList.get(1).getValue()));
                    }
                } else if (directives == Directives.SECTION) {
                    if (tokenList.size() >= 2) {
                        Token token3 = tokenList.get(1);
                        if (token3.getType() == TokenTypes.QUOTED_STRING || token3.getType() == TokenTypes.IDENTIFIER) {
                            String string = token3.getValue();
                            if (string.startsWith(".data") || string.startsWith(".rodata") || string.startsWith(".sdata")) {
                                this.inDataSegment = true;
                            } else if (string.startsWith(".text")) {
                                this.inDataSegment = false;
                            } else {
                                this.errors.add(new ErrorMessage(true, token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "section name \"" + string + "\" is ignored"));
                            }
                        } else {
                            this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), ".section must be followed by a section name "));
                        }
                    } else {
                        this.errors.add(new ErrorMessage(true, token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), ".section without arguments is ignored"));
                    }
                } else if (directives == Directives.WORD || directives == Directives.HALF || directives == Directives.BYTE || directives == Directives.FLOAT || directives == Directives.DOUBLE || directives == Directives.DWORD) {
                    this.dataDirective = directives;
                    if (this.passesDataSegmentCheck(token) && tokenList.size() > 1) {
                        this.storeNumeric(tokenList, directives, this.errors);
                    }
                } else if (directives == Directives.ASCII || directives == Directives.ASCIZ || directives == Directives.STRING) {
                    this.dataDirective = directives;
                    if (this.passesDataSegmentCheck(token)) {
                        this.storeStrings(tokenList, directives, this.errors);
                    }
                } else if (directives == Directives.ALIGN) {
                    if (tokenList.size() != 2) {
                        this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" requires one operand"));
                        return;
                    }
                    if (!TokenTypes.isIntegerTokenType(tokenList.get(1).getType()) || Binary.stringToInt(tokenList.get(1).getValue()) < 0) {
                        this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" requires a non-negative integer"));
                        return;
                    }
                    int n = Binary.stringToInt(tokenList.get(1).getValue());
                    if (n < 2 && !this.inDataSegment) {
                        this.errors.add(new ErrorMessage(true, token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "Alignments less than 4 bytes are not supported in the text section. The alignment has been rounded up to 4 bytes."));
                        this.dataAddress.set(this.alignToBoundary(this.dataAddress.get(), 4));
                    } else if (n == 0) {
                        this.autoAlign = false;
                    } else {
                        this.dataAddress.set(this.alignToBoundary(this.dataAddress.get(), (int)Math.pow(2.0, n)));
                    }
                } else if (directives == Directives.SPACE) {
                    if (this.passesDataSegmentCheck(token)) {
                        if (tokenList.size() != 2) {
                            this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" requires one operand"));
                            return;
                        }
                        if (!TokenTypes.isIntegerTokenType(tokenList.get(1).getType()) || Binary.stringToInt(tokenList.get(1).getValue()) < 0) {
                            this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" requires a non-negative integer"));
                            return;
                        }
                        int n = Binary.stringToInt(tokenList.get(1).getValue());
                        this.dataAddress.increment(n);
                    }
                } else if (directives == Directives.EXTERN) {
                    if (tokenList.size() != 3) {
                        this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" directive requires two operands (label and size)."));
                        return;
                    }
                    if (!TokenTypes.isIntegerTokenType(tokenList.get(2).getType()) || Binary.stringToInt(tokenList.get(2).getValue()) < 0) {
                        this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" requires a non-negative integer size"));
                        return;
                    }
                    int n = Binary.stringToInt(tokenList.get(2).getValue());
                    if (Globals.symbolTable.getAddress(tokenList.get(1).getValue()) == -1) {
                        Globals.symbolTable.addSymbol(tokenList.get(1), this.externAddress, true, this.errors);
                        this.externAddress += n;
                    }
                } else if (directives == Directives.GLOBL || directives == Directives.GLOBAL) {
                    if (tokenList.size() < 2) {
                        this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" directive requires at least one argument."));
                        return;
                    }
                    for (int i = 1; i < tokenList.size(); ++i) {
                        Token token4 = tokenList.get(i);
                        if (token4.getType() != TokenTypes.IDENTIFIER) {
                            this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" directive argument must be label."));
                            return;
                        }
                        this.globalDeclarationList.add(token4);
                    }
                } else {
                    this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" directive recognized but not yet implemented."));
                }
            }
        }
    }

    private void transferGlobals() {
        for (int i = 0; i < this.globalDeclarationList.size(); ++i) {
            Token token = this.globalDeclarationList.get(i);
            Symbol symbol = this.fileCurrentlyBeingAssembled.getLocalSymbolTable().getSymbol(token.getValue());
            if (symbol == null) {
                this.errors.add(new ErrorMessage(this.fileCurrentlyBeingAssembled, token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" declared global label but not defined."));
                continue;
            }
            if (Globals.symbolTable.getAddress(token.getValue()) != -1) {
                this.errors.add(new ErrorMessage(this.fileCurrentlyBeingAssembled, token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" already defined as global in a different file."));
                continue;
            }
            this.fileCurrentlyBeingAssembled.getLocalSymbolTable().removeSymbol(token);
            Globals.symbolTable.addSymbol(token, symbol.getAddress(), symbol.getType(), this.errors);
        }
    }

    private void executeDirectiveContinuation(TokenList tokenList) {
        Directives directives = this.dataDirective;
        if (directives == Directives.WORD || directives == Directives.HALF || directives == Directives.BYTE || directives == Directives.FLOAT || directives == Directives.DOUBLE || directives == Directives.DWORD) {
            if (tokenList.size() > 0) {
                this.storeNumeric(tokenList, directives, this.errors);
            }
        } else if ((directives == Directives.ASCII || directives == Directives.ASCIZ || directives == Directives.STRING) && this.passesDataSegmentCheck(tokenList.get(0))) {
            this.storeStrings(tokenList, directives, this.errors);
        }
    }

    private ArrayList<Instruction> matchInstruction(Token token) {
        if (token.getType() != TokenTypes.OPERATOR) {
            if (token.getSourceProgram().getLocalMacroPool().matchesAnyMacroName(token.getValue())) {
                this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "forward reference or invalid parameters for macro \"" + token.getValue() + "\""));
            } else {
                this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" is not a recognized operator"));
            }
            return null;
        }
        ArrayList<Instruction> arrayList = Globals.instructionSet.matchOperator(token.getValue());
        if (arrayList == null) {
            this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "Internal Assembler error: \"" + token.getValue() + "\" tokenized OPERATOR then not recognized"));
        }
        return arrayList;
    }

    private void storeNumeric(TokenList tokenList, Directives directives, ErrorList errorList) {
        Token token = tokenList.get(0);
        assert (this.passesDataSegmentCheck(token));
        int n = 0;
        if (token.getType() == TokenTypes.DIRECTIVE) {
            n = 1;
        }
        int n2 = DataTypes.getLengthInBytes(directives);
        if (tokenList.size() == 4 && tokenList.get(2).getType() == TokenTypes.COLON) {
            Token token2 = tokenList.get(1);
            Token token3 = tokenList.get(3);
            if (!((Directives.isIntegerDirective(directives) && TokenTypes.isIntegerTokenType(token2.getType()) || Directives.isFloatingDirective(directives) && (TokenTypes.isIntegerTokenType(token2.getType()) || TokenTypes.isFloatingTokenType(token2.getType()))) && TokenTypes.isIntegerTokenType(token3.getType()))) {
                errorList.add(new ErrorMessage(this.fileCurrentlyBeingAssembled, token2.getSourceLine(), token2.getStartPos(), "malformed expression"));
                return;
            }
            int n3 = Binary.stringToInt(token3.getValue());
            if (n3 <= 0) {
                errorList.add(new ErrorMessage(this.fileCurrentlyBeingAssembled, token3.getSourceLine(), token3.getStartPos(), "repetition factor must be positive"));
                return;
            }
            if (this.inDataSegment) {
                if (this.autoAlign) {
                    this.dataAddress.set(this.alignToBoundary(this.dataAddress.get(), n2));
                }
                for (int i = 0; i < n3; ++i) {
                    if (Directives.isIntegerDirective(directives)) {
                        this.storeInteger(token2, directives, errorList);
                        continue;
                    }
                    this.storeRealNumber(token2, directives, errorList);
                }
            }
            return;
        }
        for (int i = n; i < tokenList.size(); ++i) {
            token = tokenList.get(i);
            if (Directives.isIntegerDirective(directives)) {
                this.storeInteger(token, directives, errorList);
            }
            if (!Directives.isFloatingDirective(directives)) continue;
            this.storeRealNumber(token, directives, errorList);
        }
    }

    private void storeInteger(Token token, Directives directives, ErrorList errorList) {
        int n = DataTypes.getLengthInBytes(directives);
        if (TokenTypes.isIntegerTokenType(token.getType())) {
            int n2;
            long l;
            if (TokenTypes.INTEGER_64 == token.getType()) {
                l = Binary.stringToLong(token.getValue());
                n2 = (int)l;
                if (directives != Directives.DWORD) {
                    errorList.add(new ErrorMessage(true, token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "value " + Binary.longToHexString(l) + " is out-of-range and truncated to " + Binary.intToHexString(n2)));
                }
            } else {
                n2 = Binary.stringToInt(token.getValue());
                l = n2;
            }
            if (directives == Directives.DWORD) {
                this.writeToDataSegment((int)l, 4, token, errorList);
                this.writeToDataSegment((int)(l >> 32), 4, token, errorList);
                return;
            }
            int n3 = n2;
            if (directives == Directives.BYTE) {
                n2 &= 0xFF;
            } else if (directives == Directives.HALF) {
                n2 &= 0xFFFF;
            }
            if (DataTypes.outOfRange(directives, n3)) {
                errorList.add(new ErrorMessage(true, token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "value " + Binary.intToHexString(n3) + " is out-of-range and truncated to " + Binary.intToHexString(n2)));
            }
            if (this.inDataSegment) {
                this.writeToDataSegment(n2, n, token, errorList);
            } else {
                try {
                    Globals.memory.set(this.textAddress.get(), n2, n);
                }
                catch (AddressErrorException addressErrorException) {
                    errorList.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + this.textAddress.get() + "\" is not a valid text segment address"));
                    return;
                }
                this.textAddress.increment(n);
            }
        } else if (token.getType() == TokenTypes.IDENTIFIER) {
            if (this.inDataSegment) {
                int n4 = this.fileCurrentlyBeingAssembled.getLocalSymbolTable().getAddressLocalOrGlobal(token.getValue());
                if (n4 == -1) {
                    int n5 = this.writeToDataSegment(0, n, token, errorList);
                    this.currentFileDataSegmentForwardReferences.add(n5, n, token);
                } else {
                    this.writeToDataSegment(n4, n, token, errorList);
                }
            } else {
                errorList.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" label as directive operand not permitted in text segment"));
            }
        } else {
            errorList.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" is not a valid integer constant or label"));
        }
    }

    private void storeRealNumber(Token token, Directives directives, ErrorList errorList) {
        double d;
        int n = DataTypes.getLengthInBytes(directives);
        if (token.getValue().equals("Inf")) {
            d = Double.POSITIVE_INFINITY;
        } else if (token.getValue().equals("-Inf")) {
            d = Double.NEGATIVE_INFINITY;
        } else if (TokenTypes.isIntegerTokenType(token.getType()) || TokenTypes.isFloatingTokenType(token.getType())) {
            try {
                d = Double.parseDouble(token.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                errorList.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" is not a valid floating point constant"));
                return;
            }
            if (DataTypes.outOfRange(directives, d)) {
                errorList.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" is an out-of-range value"));
                return;
            }
        } else {
            errorList.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" is not a valid floating point constant"));
            return;
        }
        if (directives == Directives.FLOAT) {
            this.writeToDataSegment(Float.floatToIntBits((float)d), n, token, errorList);
        }
        if (directives == Directives.DOUBLE) {
            this.writeDoubleToDataSegment(d, token, errorList);
        }
    }

    private void storeStrings(TokenList tokenList, Directives directives, ErrorList errorList) {
        int n = 0;
        if (tokenList.get(0).getType() == TokenTypes.DIRECTIVE) {
            n = 1;
        }
        for (int i = n; i < tokenList.size(); ++i) {
            Token token = tokenList.get(i);
            if (token.getType() != TokenTypes.QUOTED_STRING) {
                errorList.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" is not a valid character string"));
                continue;
            }
            String string = token.getValue();
            for (int j = 1; j < string.length() - 1; ++j) {
                Object object;
                int n2 = string.charAt(j);
                if (n2 == 92) {
                    n2 = string.charAt(++j);
                    switch (n2) {
                        case 110: {
                            n2 = 10;
                            break;
                        }
                        case 116: {
                            n2 = 9;
                            break;
                        }
                        case 114: {
                            n2 = 13;
                            break;
                        }
                        case 92: {
                            n2 = 92;
                            break;
                        }
                        case 39: {
                            n2 = 39;
                            break;
                        }
                        case 34: {
                            n2 = 34;
                            break;
                        }
                        case 98: {
                            n2 = 8;
                            break;
                        }
                        case 102: {
                            n2 = 12;
                            break;
                        }
                        case 48: {
                            n2 = 0;
                            break;
                        }
                        case 117: {
                            object = "";
                            try {
                                object = string.substring(j + 1, j + 5);
                                n2 = Character.toChars(Integer.parseInt((String)object, 16))[0];
                            }
                            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                                String string2 = string.substring(j + 1);
                                errorList.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "unicode escape \"\\u" + string2 + "\" is incomplete. Only escapes with 4 digits are valid."));
                            }
                            catch (NumberFormatException numberFormatException) {
                                errorList.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "illegal unicode escape: \"\\u" + (String)object + "\""));
                            }
                            j += 4;
                        }
                    }
                }
                object = String.valueOf((char)n2).getBytes(StandardCharsets.UTF_8);
                try {
                    for (byte by : object) {
                        Globals.memory.set(this.dataAddress.get(), by, 1);
                        this.dataAddress.increment(1);
                    }
                    continue;
                }
                catch (AddressErrorException addressErrorException) {
                    errorList.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + this.dataAddress.get() + "\" is not a valid data segment address"));
                }
            }
            if (directives != Directives.ASCIZ && directives != Directives.STRING) continue;
            try {
                Globals.memory.set(this.dataAddress.get(), 0, 1);
            }
            catch (AddressErrorException addressErrorException) {
                errorList.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + this.dataAddress.get() + "\" is not a valid data segment address"));
            }
            this.dataAddress.increment(1);
        }
    }

    private boolean passesDataSegmentCheck(Token token) {
        if (!this.inDataSegment) {
            this.errors.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\" directive cannot appear in text segment"));
            return false;
        }
        return true;
    }

    private int writeToDataSegment(int n, int n2, Token token, ErrorList errorList) {
        if (this.autoAlign) {
            this.dataAddress.set(this.alignToBoundary(this.dataAddress.get(), n2));
        }
        try {
            Globals.memory.set(this.dataAddress.get(), n, n2);
        }
        catch (AddressErrorException addressErrorException) {
            errorList.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + this.dataAddress.get() + "\" is not a valid data segment address"));
            return this.dataAddress.get();
        }
        int n3 = this.dataAddress.get();
        this.dataAddress.increment(n2);
        return n3;
    }

    private void writeDoubleToDataSegment(double d, Token token, ErrorList errorList) {
        int n = 8;
        if (this.autoAlign) {
            this.dataAddress.set(this.alignToBoundary(this.dataAddress.get(), n));
        }
        try {
            Globals.memory.setDouble(this.dataAddress.get(), d);
        }
        catch (AddressErrorException addressErrorException) {
            errorList.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + this.dataAddress.get() + "\" is not a valid data segment address"));
            return;
        }
        this.dataAddress.increment(n);
    }

    private int alignToBoundary(int n, int n2) {
        int n3 = n % n2;
        if (n3 == 0) {
            return n;
        }
        int n4 = n + n2 - n3;
        this.fileCurrentlyBeingAssembled.getLocalSymbolTable().fixSymbolTableAddress(n, n4);
        return n4;
    }

    private class AddressSpace {
        int address;

        private AddressSpace(int n) {
            this.address = n;
        }

        private int get() {
            return this.address;
        }

        private void set(int n) {
            this.address = n;
        }

        private void increment(int n) {
            this.address += n;
        }
    }

    private class DataSegmentForwardReferences {
        private ArrayList<DataSegmentForwardReference> forwardReferenceList = new ArrayList();

        private DataSegmentForwardReferences() {
        }

        private int size() {
            return this.forwardReferenceList.size();
        }

        private void add(int n, int n2, Token token) {
            this.forwardReferenceList.add(new DataSegmentForwardReference(n, n2, token));
        }

        private void add(DataSegmentForwardReferences dataSegmentForwardReferences) {
            this.forwardReferenceList.addAll(dataSegmentForwardReferences.forwardReferenceList);
        }

        private void clear() {
            this.forwardReferenceList.clear();
        }

        private void resolve(SymbolTable symbolTable) {
            for (int i = 0; i < this.forwardReferenceList.size(); ++i) {
                DataSegmentForwardReference dataSegmentForwardReference = this.forwardReferenceList.get(i);
                int n = symbolTable.getAddressLocalOrGlobal(dataSegmentForwardReference.token.getValue());
                if (n == -1) continue;
                try {
                    Globals.memory.set(dataSegmentForwardReference.patchAddress, n, dataSegmentForwardReference.length);
                }
                catch (AddressErrorException addressErrorException) {
                    // empty catch block
                }
                this.forwardReferenceList.remove(i);
                --i;
            }
        }

        private void generateErrorMessages(ErrorList errorList) {
            for (DataSegmentForwardReference dataSegmentForwardReference : this.forwardReferenceList) {
                errorList.add(new ErrorMessage(dataSegmentForwardReference.token.getSourceProgram(), dataSegmentForwardReference.token.getSourceLine(), dataSegmentForwardReference.token.getStartPos(), "Symbol \"" + dataSegmentForwardReference.token.getValue() + "\" not found in symbol table."));
            }
        }

        private class DataSegmentForwardReference {
            int patchAddress;
            int length;
            Token token;

            DataSegmentForwardReference(int n, int n2, Token token) {
                this.patchAddress = n;
                this.length = n2;
                this.token = token;
            }
        }
    }
}

