/*
 * Decompiled with CFR 0.152.
 */
package jsoftfloat.types;

import java.math.BigInteger;
import jsoftfloat.Environment;
import jsoftfloat.Flags;
import jsoftfloat.RoundingMode;
import jsoftfloat.internal.ExactFloat;
import jsoftfloat.types.Floating;

public class Float64
extends Floating<Float64> {
    public static final Float64 Zero = new Float64(0L);
    public static final Float64 NegativeZero = new Float64(Long.MIN_VALUE);
    public static final Float64 NaN = new Float64(9221120237041090560L);
    public static final Float64 Infinity = new Float64(0x7FF0000000000000L);
    public static final Float64 NegativeInfinity = new Float64(-4503599627370496L);
    public final long bits;
    private static final int sigbits = 52;
    private static final int expbits = 11;
    private static final int maxexp = 1024;
    private static final int minexp = -1023;
    private static final long sigmask = 0xFFFFFFFFFFFFFL;

    public Float64(long l) {
        this.bits = l;
    }

    public Float64(boolean bl, int n, long l) {
        this((bl ? Long.MIN_VALUE : 0L) | ((long)(n + 1023) & 0x7FFL) << 52 | l & 0xFFFFFFFFFFFFFL);
    }

    public int exponent() {
        return ((int)(this.bits >>> 52) & 0x7FF) - 1023;
    }

    public static Float64 fromInteger(long l) {
        if (l == 0L) {
            return Zero;
        }
        boolean bl = l < 0L;
        l = bl ? -l : l;
        int n = 0;
        long l2 = 0L;
        for (int i = 62; i >= 0; --i) {
            if ((l >> i & 1L) != 1L) continue;
            n = i;
            l2 = l << 64 - i >>> 11;
            break;
        }
        return new Float64(bl, n, l2);
    }

    @Override
    public Float64 negate() {
        return new Float64(this.bits ^ Long.MIN_VALUE);
    }

    public Float64 abs() {
        return new Float64(this.bits & Long.MAX_VALUE);
    }

    public Float64 copySign(Float64 float64) {
        return new Float64(this.bits & Long.MAX_VALUE | float64.bits & Long.MIN_VALUE);
    }

    @Override
    public boolean isSignMinus() {
        return this.bits >>> 63 == 1L;
    }

    @Override
    public boolean isInfinite() {
        return this.exponent() == 1024 && (this.bits & 0xFFFFFFFFFFFFFL) == 0L;
    }

    @Override
    public boolean isNormal() {
        return this.exponent() != -1023 && this.exponent() != 1024;
    }

    @Override
    public boolean isSubnormal() {
        return this.exponent() == -1023 && !this.isZero();
    }

    @Override
    public boolean isNaN() {
        return this.exponent() == 1024 && !this.isInfinite();
    }

    @Override
    public boolean isSignalling() {
        if (!this.isNaN()) {
            return false;
        }
        return (this.bits & 0x8000000000000L) == 0L;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public boolean isZero() {
        return this.bits == 0L || this.bits == Long.MIN_VALUE;
    }

    @Override
    public Float64 NaN() {
        return NaN;
    }

    @Override
    public Float64 Zero() {
        return Zero;
    }

    @Override
    public Float64 NegativeZero() {
        return NegativeZero;
    }

    @Override
    public Float64 Infinity() {
        return Infinity;
    }

    @Override
    public Float64 NegativeInfinity() {
        return NegativeInfinity;
    }

    @Override
    public Float64 fromExactFloat(ExactFloat exactFloat, Environment environment) {
        Float64 float64;
        Float64 float642;
        BigInteger bigInteger;
        int n;
        if (exactFloat.isZero()) {
            return exactFloat.sign ? NegativeZero : Zero;
        }
        exactFloat = exactFloat.normalize();
        int n2 = exactFloat.exponent + exactFloat.significand.bitLength();
        if (n2 <= -1022) {
            if (exactFloat.exponent > -1075) {
                assert (exactFloat.significand.bitLength() <= 52) : "Its actually normal";
                return new Float64(exactFloat.sign, -1023, exactFloat.significand.shiftLeft(1074 + exactFloat.exponent).longValueExact());
            }
            environment.flags.add(Flags.inexact);
            environment.flags.add(Flags.underflow);
            n = -1074 - exactFloat.exponent;
            BigInteger bigInteger2 = exactFloat.significand.shiftRight(n).shiftLeft(n);
            bigInteger = exactFloat.significand.subtract(bigInteger2);
            float642 = new Float64(exactFloat.sign, -1023, exactFloat.significand.shiftRight(n).longValueExact());
            BigInteger bigInteger3 = exactFloat.significand.shiftRight(n).add(BigInteger.valueOf(1L));
            if (bigInteger3.testBit(0) || bigInteger3.bitLength() <= 52) {
                assert (bigInteger3.bitLength() <= 52);
                float64 = new Float64(exactFloat.sign, -1023, bigInteger3.longValueExact());
            } else {
                float64 = new Float64(exactFloat.sign, -1022, bigInteger3.longValueExact() & 0xFFFFFFFFFFFFFL);
            }
        } else {
            if (n2 > 1024) {
                environment.flags.add(Flags.overflow);
                environment.flags.add(Flags.inexact);
                switch (environment.mode) {
                    case zero: {
                        return new Float64(exactFloat.sign, 1023, -1L);
                    }
                    case min: 
                    case max: {
                        if (exactFloat.sign != (environment.mode == RoundingMode.max)) {
                            return exactFloat.sign ? NegativeInfinity : Infinity;
                        }
                        return new Float64(exactFloat.sign, 1023, -1L);
                    }
                    case away: 
                    case even: {
                        return exactFloat.sign ? NegativeInfinity : Infinity;
                    }
                }
                assert (false) : "Not reachable";
                return exactFloat.sign ? NegativeInfinity : Infinity;
            }
            if (exactFloat.significand.bitLength() <= 53) {
                assert (exactFloat.exponent + exactFloat.significand.bitLength() - 1 > -1023) : "Its actually subnormal";
                Float64 float643 = new Float64(exactFloat.sign, exactFloat.exponent + exactFloat.significand.bitLength() - 1, exactFloat.significand.shiftLeft(53 - exactFloat.significand.bitLength()).longValueExact() & 0xFFFFFFFFFFFFFL);
                return float643;
            }
            environment.flags.add(Flags.inexact);
            n = exactFloat.significand.bitLength() - 53;
            BigInteger bigInteger4 = exactFloat.significand.shiftRight(n).shiftLeft(n);
            bigInteger = exactFloat.significand.subtract(bigInteger4);
            BigInteger bigInteger5 = exactFloat.significand.shiftRight(n).add(BigInteger.valueOf(1L));
            float642 = new Float64(exactFloat.sign, exactFloat.exponent + 52 + n, exactFloat.significand.shiftRight(n).longValueExact() & 0xFFFFFFFFFFFFFL);
            float64 = bigInteger5.testBit(0) || bigInteger5.bitLength() <= 53 ? new Float64(exactFloat.sign, exactFloat.exponent + 52 + n, bigInteger5.longValueExact() & 0xFFFFFFFFFFFFFL) : new Float64(exactFloat.sign, exactFloat.exponent + 53 + n, bigInteger5.shiftRight(1).longValueExact() & 0xFFFFFFFFFFFFFL);
        }
        switch (environment.mode) {
            case zero: {
                return float642;
            }
            case min: 
            case max: {
                if (exactFloat.sign != (environment.mode == RoundingMode.max)) {
                    return float64;
                }
                return float642;
            }
        }
        if (bigInteger.equals(BigInteger.ONE.shiftLeft(n - 1))) {
            if (environment.mode == RoundingMode.away || (float64.bits & 1L) == 0L) {
                return float64;
            }
            return float642;
        }
        if (bigInteger.compareTo(BigInteger.ONE.shiftLeft(n - 1)) > 0) {
            return float64;
        }
        return float642;
    }

    public static Float64 fromExact(ExactFloat exactFloat, Environment environment) {
        return Zero.fromExactFloat(exactFloat, environment);
    }

    @Override
    public ExactFloat toExactFloat() {
        BigInteger bigInteger;
        int n;
        assert (!this.isInfinite()) : "Infinity is not exact";
        assert (!this.isNaN()) : "NaNs are not exact";
        assert (!this.isZero()) : "Zeros should be handled explicitly";
        boolean bl = this.isSignMinus();
        if (this.isZero()) {
            n = 0;
            bigInteger = BigInteger.ZERO;
        } else if (this.isNormal()) {
            n = this.exponent() - 52;
            bigInteger = BigInteger.valueOf((this.bits & 0xFFFFFFFFFFFFFL) + 0x10000000000000L);
        } else if (this.isSubnormal()) {
            n = this.exponent() - 51;
            bigInteger = BigInteger.valueOf(this.bits & 0xFFFFFFFFFFFFFL);
        } else {
            assert (false) : "This should not be reachable";
            return null;
        }
        return new ExactFloat(bl, n, bigInteger);
    }

    @Override
    public int maxPrecision() {
        return 60;
    }
}

