/*
 * Decompiled with CFR 0.152.
 */
package jsoftfloat.operations;

import jsoftfloat.Environment;
import jsoftfloat.Flags;
import jsoftfloat.types.Floating;

public class Comparisons {
    private static <T extends Floating<T>> int compareNoNAN(T t, T t2) {
        if (t.isZero()) {
            if (t2.isZero()) {
                return 0;
            }
            return t2.isSignMinus() ? 1 : -1;
        }
        if (t2.isZero()) {
            return t.isSignMinus() ? -1 : 1;
        }
        if (t.isInfinite()) {
            if (t2.isInfinite() && t.isSignMinus() == t2.isSignMinus()) {
                return 0;
            }
            return t.isSignMinus() ? 1 : -1;
        }
        if (t2.isInfinite()) {
            return t2.isSignMinus() ? 1 : -1;
        }
        return t.toExactFloat().compareTo(t2.toExactFloat());
    }

    private static <T extends Floating<T>> T nonNaNmin(T t, T t2) {
        if (t.isSignMinus() != t2.isSignMinus()) {
            return t.isSignMinus() ? t : t2;
        }
        if (t.isInfinite() || t2.isInfinite()) {
            if (t.isInfinite() == t.isSignMinus()) {
                return t;
            }
            return t2;
        }
        if (Comparisons.compareNoNAN(t, t2) <= 0) {
            return t;
        }
        return t2;
    }

    private static <T extends Floating<T>> T handleNaN(T t, T t2, Environment environment) {
        if (t.isNaN()) {
            if (t2.isNaN()) {
                return t2.NaN();
            }
            return t2;
        }
        if (t2.isNaN()) {
            return t;
        }
        return null;
    }

    private static <T extends Floating<T>> T handleNaNNumber(T t, T t2, Environment environment) {
        if (t.isSignalling() || t2.isSignalling()) {
            environment.flags.add(Flags.invalid);
        }
        return Comparisons.handleNaN(t, t2, environment);
    }

    public static <T extends Floating<T>> T minimum(T t, T t2, Environment environment) {
        T t3 = Comparisons.handleNaN(t, t2, environment);
        if (t3 != null) {
            return t3;
        }
        return Comparisons.nonNaNmin(t, t2);
    }

    public static <T extends Floating<T>> T maximum(T t, T t2, Environment environment) {
        T t3 = Comparisons.handleNaN(t, t2, environment);
        if (t3 != null) {
            return t3;
        }
        t3 = Comparisons.nonNaNmin(t, t2);
        return t == t3 ? t2 : t;
    }

    public static <T extends Floating<T>> T minimumNumber(T t, T t2, Environment environment) {
        T t3 = Comparisons.handleNaNNumber(t, t2, environment);
        if (t3 != null) {
            return t3;
        }
        return Comparisons.nonNaNmin(t, t2);
    }

    public static <T extends Floating<T>> T maximumNumber(T t, T t2, Environment environment) {
        T t3 = Comparisons.handleNaNNumber(t, t2, environment);
        if (t3 != null) {
            return t3;
        }
        t3 = Comparisons.nonNaNmin(t, t2);
        return t == t3 ? t2 : t;
    }

    public static <T extends Floating<T>> T minNum(T t, T t2, Environment environment) {
        if (t.isSignalling() || t2.isSignalling()) {
            environment.flags.add(Flags.invalid);
            return t.NaN();
        }
        T t3 = Comparisons.handleNaN(t, t2, environment);
        if (t3 != null) {
            return t3;
        }
        return Comparisons.nonNaNmin(t, t2);
    }

    public static <T extends Floating<T>> T maxNum(T t, T t2, Environment environment) {
        if (t.isSignalling() || t2.isSignalling()) {
            environment.flags.add(Flags.invalid);
            return t.NaN();
        }
        T t3 = Comparisons.handleNaN(t, t2, environment);
        if (t3 != null) {
            return t3;
        }
        t3 = Comparisons.nonNaNmin(t, t2);
        return t == t3 ? t2 : t;
    }

    public static <T extends Floating<T>> boolean compareQuietEqual(T t, T t2, Environment environment) {
        if (t.isSignalling() || t2.isSignalling()) {
            environment.flags.add(Flags.invalid);
        }
        if (t.isNaN() || t2.isNaN()) {
            return false;
        }
        return Comparisons.compareNoNAN(t, t2) == 0;
    }

    public static <T extends Floating<T>> boolean equalSignaling(T t, T t2, Environment environment) {
        if (t.isNaN() || t2.isNaN()) {
            environment.flags.add(Flags.invalid);
        }
        return Comparisons.compareQuietEqual(t, t2, environment);
    }

    public static <T extends Floating<T>> boolean compareQuietLessThan(T t, T t2, Environment environment) {
        if (t.isSignalling() || t2.isSignalling()) {
            environment.flags.add(Flags.invalid);
        }
        if (t.isNaN() || t2.isNaN()) {
            return false;
        }
        return Comparisons.compareNoNAN(t, t2) < 0;
    }

    public static <T extends Floating<T>> boolean compareSignalingLessThan(T t, T t2, Environment environment) {
        if (t.isNaN() || t2.isNaN()) {
            environment.flags.add(Flags.invalid);
        }
        return Comparisons.compareQuietLessThan(t, t2, environment);
    }

    public static <T extends Floating<T>> boolean compareQuietLessThanEqual(T t, T t2, Environment environment) {
        if (t.isSignalling() || t2.isSignalling()) {
            environment.flags.add(Flags.invalid);
        }
        if (t.isNaN() || t2.isNaN()) {
            return false;
        }
        return Comparisons.compareNoNAN(t, t2) <= 0;
    }

    public static <T extends Floating<T>> boolean compareSignalingLessThanEqual(T t, T t2, Environment environment) {
        if (t.isNaN() || t2.isNaN()) {
            environment.flags.add(Flags.invalid);
        }
        return Comparisons.compareQuietLessThanEqual(t, t2, environment);
    }

    public static <T extends Floating<T>> boolean compareQuietGreaterThan(T t, T t2, Environment environment) {
        if (t.isSignalling() || t2.isSignalling()) {
            environment.flags.add(Flags.invalid);
        }
        if (t.isNaN() || t2.isNaN()) {
            return false;
        }
        return Comparisons.compareNoNAN(t, t2) > 0;
    }

    public static <T extends Floating<T>> boolean compareSignalingGreaterThan(T t, T t2, Environment environment) {
        if (t.isNaN() || t2.isNaN()) {
            environment.flags.add(Flags.invalid);
        }
        return Comparisons.compareQuietGreaterThan(t, t2, environment);
    }

    public static <T extends Floating<T>> boolean compareQuietGreaterThanEqual(T t, T t2, Environment environment) {
        if (t.isSignalling() || t2.isSignalling()) {
            environment.flags.add(Flags.invalid);
        }
        if (t.isNaN() || t2.isNaN()) {
            return false;
        }
        return Comparisons.compareNoNAN(t, t2) >= 0;
    }

    public static <T extends Floating<T>> boolean compareSignalingGreaterThanEqual(T t, T t2, Environment environment) {
        if (t.isNaN() || t2.isNaN()) {
            environment.flags.add(Flags.invalid);
        }
        return Comparisons.compareQuietGreaterThanEqual(t, t2, environment);
    }

    public static <T extends Floating<T>> boolean compareQuietUnordered(T t, T t2, Environment environment) {
        if (t.isSignalling() || t2.isSignalling()) {
            environment.flags.add(Flags.invalid);
        }
        return t.isNaN() || t2.isNaN();
    }
}

